/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.transaction.manager.RemoteXid;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.tx.XidImpl;

public class RecoveryOperation
extends RetryOnFailureOperation<Collection<Xid>> {
    public RecoveryOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg) {
        super((short)123, (short)124, codec, channelFactory, DEFAULT_CACHE_NAME_BYTES, topologyId, 0, cfg, null);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (status != 0) {
            this.complete(Collections.emptyList());
            return;
        }
        int size = ByteBufUtil.readVInt(buf);
        if (size == 0) {
            this.complete(Collections.emptyList());
            return;
        }
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>(size);
        for (int i = 0; i < size; ++i) {
            int formatId = SignedNumeric.decode(ByteBufUtil.readVInt(buf));
            byte[] globalId = ByteBufUtil.readArray(buf);
            byte[] branchId = ByteBufUtil.readArray(buf);
            xids.add(RemoteXid.create(formatId, globalId, branchId));
        }
        this.complete(xids);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.estimateSize());
        this.codec.writeHeader(buf, this.header);
        channel.writeAndFlush(buf);
    }

    private int estimateSize() {
        return this.codec.estimateHeaderSize(this.header);
    }
}

