/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.permission.ElytronMessages;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionVerifier;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String permissionCollectionMustBeReadOnly$str() {
        return "ELY03013: Permission collection must be read-only";
    }

    @Override
    public final SecurityException permissionCollectionMustBeReadOnly() {
        SecurityException result2 = new SecurityException(String.format(this.getLoggingLocale(), this.permissionCollectionMustBeReadOnly$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String permissionClassMissing$str() {
        return "ELY03015: Could not load permission class \"%s\"";
    }

    @Override
    public final InvalidPermissionClassException permissionClassMissing(String className, ClassNotFoundException cause) {
        InvalidPermissionClassException result2 = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.permissionClassMissing$str(), className), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String permissionInstantiation$str() {
        return "ELY03016: Could not instantiate permission class \"%s\"";
    }

    @Override
    public final InvalidPermissionClassException permissionInstantiation(String className, Throwable cause) {
        InvalidPermissionClassException result2 = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.permissionInstantiation$str(), className), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String noPermissionConstructor$str() {
        return "ELY03017: No valid permission constructor found on class \"%s\"";
    }

    @Override
    public final InvalidPermissionClassException noPermissionConstructor(String className) {
        InvalidPermissionClassException result2 = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.noPermissionConstructor$str(), className));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String readOnlyPermissionCollection$str() {
        return "ELY03018: Cannot add permissions to a read-only permission collection";
    }

    @Override
    public final SecurityException readOnlyPermissionCollection() {
        SecurityException result2 = new SecurityException(String.format(this.getLoggingLocale(), this.readOnlyPermissionCollection$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidObjectNull$str() {
        return "ELY03019: Failure to deserialize object: field \"%s\" is null";
    }

    @Override
    public final InvalidObjectException invalidObjectNull(String fieldName) {
        InvalidObjectException result2 = new InvalidObjectException(String.format(this.getLoggingLocale(), this.invalidObjectNull$str(), fieldName));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String expectedEmptyActions$str() {
        return "ELY03020: Expected empty actions string, got \"%s\"";
    }

    @Override
    public final IllegalArgumentException expectedEmptyActions(String actions) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedEmptyActions$str(), actions));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String invalidPermissionType$str() {
        return "ELY03021: Invalid permission type; expected %s, got %s";
    }

    @Override
    public final IllegalArgumentException invalidPermissionType(Class<? extends Permission> expected, Permission actual) {
        IllegalArgumentException result2 = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPermissionType$str(), expected, actual));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }

    protected String permissionCheckFailed$str() {
        return "ELY03022: Permission check failed: %s is not implied by %s";
    }

    @Override
    public final SecurityException permissionCheckFailed(Permission permission, PermissionVerifier permissionVerifier) {
        SecurityException result2 = new SecurityException(String.format(this.getLoggingLocale(), this.permissionCheckFailed$str(), permission, permissionVerifier));
        ElytronMessages_$logger._copyStackTraceMinusOne(result2);
        return result2;
    }
}

