/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.wildfly.common.Assert;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractSaslParticipant;
import org.wildfly.security.sasl.util.SaslWrapper;

abstract class AbstractGssapiMechanism
extends AbstractSaslParticipant {
    private static final String AUTH = "auth";
    private static final String AUTH_INT = "auth-int";
    private static final String AUTH_CONF = "auth-conf";
    private static final byte NO_SECURITY_LAYER = 1;
    private static final byte INTEGRITY_PROTECTION = 2;
    private static final byte CONFIDENTIALITY_PROTECTION = 4;
    protected static final int DEFAULT_MAX_BUFFER_SIZE = 0xFFFFFF;
    protected GSSContext gssContext;
    protected final int configuredMaxReceiveBuffer;
    protected int actualMaxReceiveBuffer;
    protected int maxBuffer;
    protected final boolean relaxComplianceChecks;
    protected final QOP[] orderedQops;
    protected QOP selectedQop;

    protected AbstractGssapiMechanism(String mechanismName, String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) throws SaslException {
        super(mechanismName, protocol, serverName, callbackHandler, ElytronMessages.saslGssapi);
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        if (props == null) {
            props = Collections.emptyMap();
        }
        if (props.containsKey("javax.security.sasl.maxbuffer")) {
            this.configuredMaxReceiveBuffer = Integer.parseInt((String)props.get("javax.security.sasl.maxbuffer"));
            if (this.configuredMaxReceiveBuffer > 0xFFFFFF) {
                throw ElytronMessages.saslGssapi.mechReceiveBufferIsGreaterThanMaximum(this.configuredMaxReceiveBuffer, 0xFFFFFF).toSaslException();
            }
        } else {
            this.configuredMaxReceiveBuffer = 0xFFFFFF;
        }
        this.relaxComplianceChecks = props.containsKey("wildfly.sasl.relax-compliance") ? Boolean.parseBoolean((String)props.get("wildfly.sasl.relax-compliance")) : false;
        this.orderedQops = this.parsePreferredQop((String)props.get("javax.security.sasl.qop"));
        if (ElytronMessages.saslGssapi.isTraceEnabled()) {
            ElytronMessages.saslGssapi.tracef("configuredMaxReceiveBuffer=%d", this.configuredMaxReceiveBuffer);
            ElytronMessages.saslGssapi.tracef("relaxComplianceChecks=%b", (Object)this.relaxComplianceChecks);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.orderedQops.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((Object)this.orderedQops[i]);
            }
            ElytronMessages.saslGssapi.tracef("QOP={%s}", (Object)sb.toString());
        }
    }

    protected int networkOrderBytesToInt(byte[] bytes, int start, int length) {
        int result2 = 0;
        for (int i = start; i < length + start; ++i) {
            result2 <<= 8;
            result2 |= bytes[i] & 0xFF;
        }
        return result2;
    }

    protected byte[] intToNetworkOrderBytes(int value) {
        byte[] response = new byte[3];
        int workingValue = value;
        for (int i = response.length - 1; i >= 0; --i) {
            response[i] = (byte)(workingValue & 0xFF);
            workingValue >>>= 8;
        }
        return response;
    }

    @Override
    public void dispose() throws SaslException {
        try {
            ElytronMessages.saslGssapi.trace("dispose");
            this.gssContext.dispose();
        }
        catch (GSSException e) {
            throw ElytronMessages.saslGssapi.mechUnableToDisposeGssContext(e).toSaslException();
        }
        finally {
            this.gssContext = null;
        }
    }

    protected QOP[] parsePreferredQop(String qop) throws SaslException {
        String[] qopNames;
        if (qop != null && (qopNames = qop.trim().split("\\s*,\\s*")).length > 0) {
            QOP[] preferredQop = new QOP[qopNames.length];
            for (int i = 0; i < qopNames.length; ++i) {
                QOP mapped = QOP.mapFromName(qopNames[i]);
                if (mapped == null) {
                    throw ElytronMessages.saslGssapi.mechUnexpectedQop(qopNames[i]).toSaslException();
                }
                preferredQop[i] = mapped;
            }
            return preferredQop;
        }
        return new QOP[]{QOP.AUTH};
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        this.assertComplete();
        switch (propName) {
            case "javax.security.sasl.qop": {
                return this.selectedQop.getName();
            }
            case "javax.security.sasl.maxbuffer": {
                return Integer.toString(this.actualMaxReceiveBuffer != 0 ? this.actualMaxReceiveBuffer : this.configuredMaxReceiveBuffer);
            }
            case "javax.security.sasl.rawsendsize": {
                return Integer.toString(this.maxBuffer);
            }
        }
        return null;
    }

    protected class GssapiWrapper
    implements SaslWrapper {
        private final boolean confidential;

        protected GssapiWrapper(boolean confidential) {
            this.confidential = confidential;
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            MessageProp prop = new MessageProp(0, this.confidential);
            try {
                byte[] response = AbstractGssapiMechanism.this.gssContext.wrap(outgoing, offset, len, prop);
                ElytronMessages.saslGssapi.tracef("Wrapping message of length '%d' resulting message of length '%d'", len, response.length);
                return response;
            }
            catch (GSSException e) {
                throw ElytronMessages.saslGssapi.mechUnableToWrapMessage(e).toSaslException();
            }
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            MessageProp prop = new MessageProp(0, this.confidential);
            try {
                byte[] response = AbstractGssapiMechanism.this.gssContext.unwrap(incoming, offset, len, prop);
                ElytronMessages.saslGssapi.tracef("Unwrapping message of length '%d' resulting message of length '%d'", len, response.length);
                return response;
            }
            catch (GSSException e) {
                throw ElytronMessages.saslGssapi.mechUnableToUnwrapMessage(e).toSaslException();
            }
        }
    }

    protected static enum QOP {
        AUTH("auth", 1),
        AUTH_INT("auth-int", 2),
        AUTH_CONF("auth-conf", 4);

        private final String name;
        private final byte value;

        private QOP(String name, byte value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean includedBy(byte securityLayer) {
            return (securityLayer & this.value) == this.value;
        }

        public static QOP mapFromValue(byte value) {
            switch (value) {
                case 1: {
                    return AUTH;
                }
                case 2: {
                    return AUTH_INT;
                }
                case 4: {
                    return AUTH_CONF;
                }
            }
            return null;
        }

        public static QOP mapFromName(String name) {
            switch (name) {
                case "auth": {
                    return AUTH;
                }
                case "auth-int": {
                    return AUTH_INT;
                }
                case "auth-conf": {
                    return AUTH_CONF;
                }
            }
            return null;
        }
    }
}

