/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.context;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextController;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ArcContextProvider
implements ThreadContextProvider {
    protected static final ThreadContextController NOOP_CONTROLLER = new ThreadContextController(){

        @Override
        public void endContext() throws IllegalStateException {
        }
    };
    private static final ThreadContextSnapshot NULL_CONTEXT_SNAPSHOT = new NullContextSnapshot();
    private static final ThreadContextSnapshot CLEAR_CONTEXT_SNAPSHOT = new ClearContextSnapshot();

    @Override
    public ThreadContextSnapshot currentContext(Map<String, String> map) {
        ArcContainer container = Arc.container();
        if (container == null) {
            return null;
        }
        InjectableContext.ContextState state = container.requestContext().getStateIfActive();
        if (state == null) {
            return NULL_CONTEXT_SNAPSHOT;
        }
        return new ContextSnapshot(state);
    }

    @Override
    public ThreadContextSnapshot clearedContext(Map<String, String> map) {
        ArcContainer container = Arc.container();
        if (container == null) {
            return null;
        }
        return CLEAR_CONTEXT_SNAPSHOT;
    }

    @Override
    public String getThreadContextType() {
        return "CDI";
    }

    private static final class RestoreContextController
    implements ThreadContextController {
        private final ManagedContext requestContext;
        private final InjectableContext.ContextState stateToRestore;

        RestoreContextController(ManagedContext requestContext, InjectableContext.ContextState stateToRestore) {
            this.requestContext = requestContext;
            this.stateToRestore = stateToRestore;
        }

        @Override
        public void endContext() throws IllegalStateException {
            this.requestContext.activate(this.stateToRestore);
        }
    }

    private static final class ContextSnapshot
    implements ThreadContextSnapshot {
        private final InjectableContext.ContextState state;

        public ContextSnapshot(InjectableContext.ContextState state) {
            this.state = state;
        }

        @Override
        public ThreadContextController begin() {
            ArcContainer container = Arc.container();
            if (container == null) {
                return NOOP_CONTROLLER;
            }
            ManagedContext requestContext = container.requestContext();
            InjectableContext.ContextState toRestore = requestContext.getStateIfActive();
            if (toRestore != null) {
                requestContext.activate(this.state);
                return new RestoreContextController(requestContext, toRestore);
            }
            requestContext.activate(this.state);
            return requestContext::deactivate;
        }
    }

    private static final class NullContextSnapshot
    implements ThreadContextSnapshot {
        private NullContextSnapshot() {
        }

        @Override
        public ThreadContextController begin() {
            ArcContainer container = Arc.container();
            if (container == null) {
                return NOOP_CONTROLLER;
            }
            final ManagedContext requestContext = container.requestContext();
            final InjectableContext.ContextState toRestore = requestContext.getStateIfActive();
            if (toRestore != null) {
                requestContext.deactivate();
                return new ThreadContextController(){

                    @Override
                    public void endContext() throws IllegalStateException {
                        requestContext.activate(toRestore);
                    }
                };
            }
            return NOOP_CONTROLLER;
        }
    }

    private static final class ClearContextSnapshot
    implements ThreadContextSnapshot {
        private ClearContextSnapshot() {
        }

        @Override
        public ThreadContextController begin() {
            ArcContainer container = Arc.container();
            if (container == null) {
                return NOOP_CONTROLLER;
            }
            ManagedContext requestContext = container.requestContext();
            InjectableContext.ContextState toRestore = requestContext.getStateIfActive();
            if (toRestore != null) {
                requestContext.activate();
                return new RestoreContextController(requestContext, toRestore);
            }
            requestContext.activate();
            return requestContext::deactivate;
        }
    }
}

