/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public class DefaultTokenIntrospectionUserInfoCache
implements TokenIntrospectionCache,
UserInfoCache {
    private static final Uni<TokenIntrospection> NULL_INTROSPECTION_UNI = Uni.createFrom().nullItem();
    private static final Uni<UserInfo> NULL_USERINFO_UNI = Uni.createFrom().nullItem();
    private OidcConfig.TokenCache cacheConfig;
    private Map<String, CacheEntry> cacheMap;
    private AtomicInteger size = new AtomicInteger();

    public DefaultTokenIntrospectionUserInfoCache(OidcConfig oidcConfig, Vertx vertx) {
        this.cacheConfig = oidcConfig.tokenCache;
        this.init(vertx);
    }

    private void init(Vertx vertx) {
        if (this.cacheConfig.maxSize > 0) {
            this.cacheMap = new ConcurrentHashMap<String, CacheEntry>();
            if (this.cacheConfig.cleanUpTimerInterval.isPresent()) {
                vertx.setPeriodic(this.cacheConfig.cleanUpTimerInterval.get().toMillis(), new Handler<Long>(){

                    @Override
                    public void handle(Long event) {
                        DefaultTokenIntrospectionUserInfoCache.this.removeInvalidEntries();
                    }
                });
            }
        } else {
            this.cacheMap = Collections.emptyMap();
        }
    }

    @Override
    public Uni<Void> addIntrospection(String token, TokenIntrospection introspection, OidcTenantConfig oidcTenantConfig, OidcRequestContext<Void> requestContext) {
        if (this.cacheConfig.maxSize > 0) {
            CacheEntry entry = this.findValidCacheEntry(token);
            if (entry != null) {
                entry.introspection = introspection;
            } else if (this.prepareSpaceForNewCacheEntry()) {
                this.cacheMap.put(token, new CacheEntry(introspection));
            }
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    @Override
    public Uni<TokenIntrospection> getIntrospection(String token, OidcTenantConfig oidcConfig, OidcRequestContext<TokenIntrospection> requestContext) {
        CacheEntry entry = this.findValidCacheEntry(token);
        return entry == null ? NULL_INTROSPECTION_UNI : Uni.createFrom().item(entry.introspection);
    }

    @Override
    public Uni<Void> addUserInfo(String token, UserInfo userInfo, OidcTenantConfig oidcTenantConfig, OidcRequestContext<Void> requestContext) {
        if (this.cacheConfig.maxSize > 0) {
            CacheEntry entry = this.findValidCacheEntry(token);
            if (entry != null) {
                entry.userInfo = userInfo;
            } else if (this.prepareSpaceForNewCacheEntry()) {
                this.cacheMap.put(token, new CacheEntry(userInfo));
            }
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    @Override
    public Uni<UserInfo> getUserInfo(String token, OidcTenantConfig oidcConfig, OidcRequestContext<UserInfo> requestContext) {
        CacheEntry entry = this.findValidCacheEntry(token);
        return entry == null ? NULL_USERINFO_UNI : Uni.createFrom().item(entry.userInfo);
    }

    public int getCacheSize() {
        return this.cacheMap.size();
    }

    public void clearCache() {
        this.cacheMap.clear();
        this.size.set(0);
    }

    private void removeInvalidEntries() {
        long now = DefaultTokenIntrospectionUserInfoCache.now();
        Iterator<Map.Entry<String, CacheEntry>> it = this.cacheMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CacheEntry> next = it.next();
            if (!this.isEntryExpired(next.getValue(), now)) continue;
            it.remove();
            this.size.decrementAndGet();
        }
    }

    private boolean prepareSpaceForNewCacheEntry() {
        int currentSize;
        do {
            if ((currentSize = this.size.get()) != this.cacheConfig.maxSize) continue;
            return false;
        } while (!this.size.compareAndSet(currentSize, currentSize + 1));
        return true;
    }

    private CacheEntry findValidCacheEntry(String token) {
        long now;
        CacheEntry entry = this.cacheMap.get(token);
        if (entry != null && this.isEntryExpired(entry, now = DefaultTokenIntrospectionUserInfoCache.now())) {
            entry = null;
            this.cacheMap.remove(token);
            this.size.decrementAndGet();
        }
        return entry;
    }

    private boolean isEntryExpired(CacheEntry entry, long now) {
        return entry.createdTime + this.cacheConfig.timeToLive.toMillis() < now;
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private static class IncrementOperator
    implements IntUnaryOperator {
        int maxSize;

        IncrementOperator(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public int applyAsInt(int n) {
            return n < this.maxSize ? n + 1 : n;
        }
    }

    private static class CacheEntry {
        volatile TokenIntrospection introspection;
        volatile UserInfo userInfo;
        long createdTime = System.currentTimeMillis();

        public CacheEntry(TokenIntrospection introspection) {
            this.introspection = introspection;
        }

        public CacheEntry(UserInfo userInfo) {
            this.userInfo = userInfo;
        }
    }
}

