/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    public static final String TYPE_PREFIX = "process";
    public static final String TYPE_FORMAT = "process.%s.%s";
    public static final String SOURCE_FORMAT = "/process/%s";
    public static final String SPEC_VERSION = "1.0";
    @JsonProperty(value="specversion")
    private String specVersion;
    private String id;
    private String source;
    private String type;
    private String time;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonProperty(value="datacontenttype")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataContentType;
    @JsonProperty(value="dataschema")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataSchema;
    private T data;
    @JsonProperty(value="kogitoprocinstanceid")
    private String kogitoProcessinstanceId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprociid")
    private String kogitoRootProcessinstanceId;
    @JsonProperty(value="kogitoprocid")
    private String kogitoProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprocid")
    private String kogitoRootProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitoaddons")
    private String kogitoAddons;

    public AbstractDataEvent() {
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons) {
        this.specVersion = SPEC_VERSION;
        this.id = UUID.randomUUID().toString();
        this.source = source;
        this.type = type;
        this.time = ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.data = body;
        this.kogitoProcessinstanceId = kogitoProcessinstanceId;
        this.kogitoRootProcessinstanceId = kogitoRootProcessinstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoAddons = kogitoAddons;
        this.ensureRequiredFields();
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons, String subject, String dataContentType, String dataSchema) {
        this(type, source, body, kogitoProcessinstanceId, kogitoRootProcessinstanceId, kogitoProcessId, kogitoRootProcessId, kogitoAddons);
        this.subject = subject;
        this.dataContentType = dataContentType;
        this.dataSchema = dataSchema;
    }

    protected void ensureRequiredFields() {
        if (this.type == null || this.type.isEmpty()) {
            this.type = TYPE_PREFIX;
        }
        if (this.source == null || this.source.isEmpty()) {
            this.source = String.format(SOURCE_FORMAT, this.kogitoProcessId);
        }
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public String getDataContentType() {
        return this.dataContentType;
    }

    @Override
    public String getDataSchema() {
        return this.dataSchema;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public String getKogitoProcessinstanceId() {
        return this.kogitoProcessinstanceId;
    }

    public String getKogitoRootProcessinstanceId() {
        return this.kogitoRootProcessinstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }
}

