/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.UUID;
import org.kie.kogito.jobs.JobId;
import org.kie.kogito.timer.TimerInstance;

public class TimerJobId
implements JobId<Long, TimerInstance> {
    public static final String SIGNAL = "timerTriggered";
    private static MessageFormat format = new MessageFormat("{0}:{1}:{2}");
    public static final String TYPE = "TIMER";
    private Long timerId;
    private String uuid;

    public TimerJobId() {
    }

    public TimerJobId(Long timerId) {
        this.timerId = timerId;
        this.uuid = UUID.randomUUID().toString();
    }

    public TimerJobId(String uuid) {
        this.uuid = uuid;
        this.timerId = 0L;
    }

    @Override
    public String encode() {
        return format.format(new Object[]{TYPE, this.timerId, this.uuid});
    }

    @Override
    public String signal() {
        return SIGNAL;
    }

    @Override
    public Long correlationId() {
        return this.timerId;
    }

    public TimerJobId decode(String value) {
        try {
            Object[] values = format.parse(value);
            this.timerId = Long.parseLong((String)values[1]);
            this.uuid = (String)values[2];
            return this;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public TimerInstance payload(Object ... parameters) {
        Integer limit = (Integer)parameters[0];
        return TimerInstance.with(this.timerId, this.encode(), limit);
    }
}

