/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.FallbackConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

public final class FallbackConfigImpl
implements FallbackConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Fallback instance;
    private final boolean onMethod;
    private Class<? extends FallbackHandler<?>> _value;
    private String _fallbackMethod;
    private Class<? extends Throwable>[] _applyOn;
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fallback;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Fallback.class, method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return this.method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    @Override
    public boolean isOnMethod() {
        return this.onMethod;
    }

    @Override
    public Class<? extends FallbackHandler<?>> value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            this._value = this.onMethod ? (Class)config.getOptionalValue(this.getConfigKeyForMethod("value"), Class.class).orElse(null) : (Class)config.getOptionalValue(this.getConfigKeyForClass("value"), Class.class).orElse(null);
            if (this._value == null) {
                this._value = config.getOptionalValue("Fallback/value", Class.class).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    @Override
    public String fallbackMethod() {
        if (this._fallbackMethod == null) {
            Config config = ConfigProvider.getConfig();
            this._fallbackMethod = this.onMethod ? (String)config.getOptionalValue(this.getConfigKeyForMethod("fallbackMethod"), String.class).orElse(null) : (String)config.getOptionalValue(this.getConfigKeyForClass("fallbackMethod"), String.class).orElse(null);
            if (this._fallbackMethod == null) {
                this._fallbackMethod = config.getOptionalValue("Fallback/fallbackMethod", String.class).orElse(null);
            }
            if (this._fallbackMethod == null) {
                this._fallbackMethod = this.instance.fallbackMethod();
            }
        }
        return this._fallbackMethod;
    }

    @Override
    public Class<? extends Throwable>[] applyOn() {
        if (this._applyOn == null) {
            Config config = ConfigProvider.getConfig();
            this._applyOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("applyOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("applyOn"), Class[].class).orElse(null);
            if (this._applyOn == null) {
                this._applyOn = config.getOptionalValue("Fallback/applyOn", Class[].class).orElse(null);
            }
            if (this._applyOn == null) {
                this._applyOn = this.instance.applyOn();
            }
        }
        return this._applyOn;
    }

    @Override
    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            Config config = ConfigProvider.getConfig();
            this._skipOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("skipOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("skipOn"), Class[].class).orElse(null);
            if (this._skipOn == null) {
                this._skipOn = config.getOptionalValue("Fallback/skipOn", Class[].class).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Fallback/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Fallback/" + key;
    }
}

