/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.cloudevents.SpecVersionDeserializer;
import org.kie.kogito.event.cloudevents.SpecVersionSerializer;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    public static final String TYPE_PREFIX = "process";
    public static final String TYPE_FORMAT = "process.%s.%s";
    public static final String SOURCE_FORMAT = "/process/%s";
    public static final String SPEC_VERSION = "1.0";
    @JsonDeserialize(using=SpecVersionDeserializer.class)
    @JsonSerialize(using=SpecVersionSerializer.class)
    @JsonProperty(value="specversion")
    private SpecVersion specVersion;
    private String id;
    private URI source;
    private String type;
    private OffsetDateTime time;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataContentType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private URI dataSchema;
    private T data;
    @JsonProperty(value="kogitoprocinstanceid")
    private String kogitoProcessinstanceId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprociid")
    private String kogitoRootProcessinstanceId;
    @JsonProperty(value="kogitoprocid")
    private String kogitoProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprocid")
    private String kogitoRootProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitoaddons")
    private String kogitoAddons;

    public AbstractDataEvent() {
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons) {
        this.specVersion = SpecVersion.parse(SPEC_VERSION);
        this.id = UUID.randomUUID().toString();
        this.source = Optional.ofNullable(source).map(URI::create).orElse(null);
        this.type = type;
        this.time = ZonedDateTime.now().toOffsetDateTime();
        this.data = body;
        this.kogitoProcessinstanceId = kogitoProcessinstanceId;
        this.kogitoRootProcessinstanceId = kogitoRootProcessinstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoAddons = kogitoAddons;
        this.ensureRequiredFields();
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons, String subject, String dataContentType, String dataSchema) {
        this(type, source, body, kogitoProcessinstanceId, kogitoRootProcessinstanceId, kogitoProcessId, kogitoRootProcessId, kogitoAddons);
        this.subject = subject;
        this.dataContentType = dataContentType;
        this.dataSchema = URI.create(dataSchema);
    }

    protected void ensureRequiredFields() {
        if (this.type == null || this.type.isEmpty()) {
            this.type = TYPE_PREFIX;
        }
        if (this.source == null) {
            this.source = URI.create(String.format(SOURCE_FORMAT, this.kogitoProcessId));
        }
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public OffsetDateTime getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public String getDataContentType() {
        return this.dataContentType;
    }

    @Override
    public URI getDataSchema() {
        return this.dataSchema;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public String getKogitoProcessinstanceId() {
        return this.kogitoProcessinstanceId;
    }

    public String getKogitoRootProcessinstanceId() {
        return this.kogitoRootProcessinstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }

    @Override
    public Object getAttribute(String name) throws IllegalArgumentException {
        return CloudEventUtils.getAttribute(name, this);
    }

    @Override
    public Object getExtension(String s) {
        return null;
    }

    @Override
    @JsonIgnore
    public Set<String> getAttributeNames() {
        return DataEvent.super.getAttributeNames();
    }

    @Override
    @JsonIgnore
    public Set<String> getExtensionNames() {
        return Collections.emptySet();
    }
}

