/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api.event.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.cloudevents.jackson.JsonFormat;
import org.kie.kogito.jobs.api.event.JobCloudEvent;
import org.kie.kogito.jobs.api.event.serialization.SerializationException;

public class JobCloudEventSerializer {
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper().registerModule(new JavaTimeModule()).registerModule(JsonFormat.getCloudEventJacksonModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private final ObjectMapper objectMapper;

    public JobCloudEventSerializer() {
        this.objectMapper = DEFAULT_OBJECT_MAPPER;
    }

    public JobCloudEventSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String serialize(JobCloudEvent<?> jobCloudEvent) {
        try {
            return this.objectMapper.writeValueAsString(jobCloudEvent);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("An error was produced during a JobCloudEvent serialization: " + e.getMessage(), e);
        }
    }
}

