/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan.marshaller;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.repository.infinispan.marshaller.BaseMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;

public class JobDetailsMarshaller
extends BaseMarshaller<JobDetails> {
    @Override
    public String getTypeName() {
        return this.getPackage() + ".JobDetails";
    }

    @Override
    public Class<? extends JobDetails> getJavaClass() {
        return JobDetails.class;
    }

    @Override
    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, JobDetails job) throws IOException {
        writer.writeString("id", job.getId());
        writer.writeString("correlationId", job.getCorrelationId());
        writer.writeString("status", this.mapEnum(job.getStatus()));
        writer.writeInstant("lastUpdate", DateUtil.zonedDateTimeToInstant(job.getLastUpdate()));
        writer.writeInt("retries", job.getRetries());
        writer.writeInt("priority", job.getPriority());
        writer.writeInt("executionCounter", job.getExecutionCounter());
        writer.writeString("scheduledId", job.getScheduledId());
        writer.writeString("payload", String.valueOf(job.getPayload()));
        writer.writeObject("recipient", job.getRecipient(), this.getInterface(job.getRecipient()));
        writer.writeObject("trigger", job.getTrigger(), this.getInterface(job.getTrigger()));
        writer.writeString("type", this.mapEnum(job.getType()));
    }

    public Class<?> getInterface(Object object) {
        return Optional.ofNullable(object).map(Object::getClass).map(Class::getInterfaces).map(i -> i[0]).orElse(null);
    }

    @Override
    public JobDetails readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String id = reader.readString("id");
        String correlationId = reader.readString("correlationId");
        JobStatus status = this.mapString(reader.readString("status"), JobStatus.class);
        ZonedDateTime lastUpdate = DateUtil.instantToZonedDateTime(reader.readInstant("lastUpdate"));
        Integer retries = reader.readInt("retries");
        Integer priority = reader.readInt("priority");
        Integer executionCounter = reader.readInt("executionCounter");
        String scheduledId = reader.readString("scheduledId");
        String payload = reader.readString("payload");
        Recipient recipient = reader.readObject("recipient", Recipient.class);
        Trigger trigger = reader.readObject("trigger", Trigger.class);
        JobDetails.Type type = this.mapString(reader.readString("type"), JobDetails.Type.class);
        return JobDetails.builder().id(id).correlationId(correlationId).status(status).lastUpdate(lastUpdate).retries(retries).priority(priority).executionCounter(executionCounter).scheduledId(scheduledId).payload(payload).recipient(recipient).trigger(trigger).type(type).build();
    }
}

