/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.BlockingConfig;
import java.lang.annotation.Annotation;

public final class BlockingConfigImpl
implements BlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Blocking instance;
    private final boolean onMethod;

    private BlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.blocking;
        this.onMethod = method.annotationsPresentDirectly.contains(Blocking.class);
    }

    public static BlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.blocking == null) {
            return null;
        }
        if (!Config.isEnabled(Blocking.class, method.method)) {
            return null;
        }
        return new BlockingConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return this.method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Blocking.class;
    }

    @Override
    public boolean isOnMethod() {
        return this.onMethod;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Blocking/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Blocking/" + key;
    }
}

