/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.internal.InternalLogger;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletionStage;

public class AsyncTypesConversion {

    public static class FromCompletionStage
    implements FaultToleranceStrategy {
        private final FaultToleranceStrategy delegate;
        private final ReactiveTypeConverter converter;

        public FromCompletionStage(FaultToleranceStrategy delegate, ReactiveTypeConverter converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object apply(InvocationContext ctx) throws Exception {
            InternalLogger.LOG.trace("AsyncTypesConversion.FromCompletionStage started");
            try {
                CompletionStage result = (CompletionStage)this.delegate.apply(ctx);
                Object t = this.converter.fromCompletionStage(result);
                return t;
            }
            finally {
                InternalLogger.LOG.trace("AsyncTypesConversion.FromCompletionStage finished");
            }
        }
    }

    public static class ToCompletionStage
    implements FaultToleranceStrategy {
        private final FaultToleranceStrategy delegate;
        private final ReactiveTypeConverter converter;

        public ToCompletionStage(FaultToleranceStrategy delegate, ReactiveTypeConverter converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object apply(InvocationContext ctx) throws Exception {
            InternalLogger.LOG.trace("AsyncTypesConversion.ToCompletionStage started");
            try {
                Object result = this.delegate.apply(ctx);
                CompletionStage completionStage = this.converter.toCompletionStage(result);
                return completionStage;
            }
            finally {
                InternalLogger.LOG.trace("AsyncTypesConversion.ToCompletionStage finished");
            }
        }
    }
}

