/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.metrics.MetricConstants;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricsProvider {
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    Provider<MetricRegistry> registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    boolean metricsEnabled;
    @Inject
    SpecCompatibility specCompatibility;

    public MetricsRecorder create(FaultToleranceOperation operation) {
        if (this.metricsEnabled) {
            return new MetricsRecorderImpl(this.registry.get(), this.specCompatibility, operation);
        }
        return MetricsRecorder.NOOP;
    }

    public boolean isEnabled() {
        return this.metricsEnabled;
    }

    private static class MetricsRecorderImpl
    implements MetricsRecorder {
        private final MetricRegistry registry;
        private final Tag methodTag;

        MetricsRecorderImpl(MetricRegistry registry, SpecCompatibility specCompatibility, FaultToleranceOperation operation) {
            this.registry = registry;
            this.methodTag = new Tag("method", operation.getName());
            this.registerMetrics(specCompatibility, operation);
        }

        private void registerMetrics(SpecCompatibility specCompatibility, FaultToleranceOperation operation) {
            if (operation.hasFallback()) {
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_NOT_APPLIED).getCount();
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_APPLIED).getCount();
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_NOT_APPLIED).getCount();
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_APPLIED).getCount();
            } else {
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_VALUE_RETURNED, MetricConstants.FALLBACK_NOT_DEFINED).getCount();
                this.registry.counter("ft.invocations.total", this.methodTag, MetricConstants.RESULT_EXCEPTION_THROWN, MetricConstants.FALLBACK_NOT_DEFINED).getCount();
            }
            if (operation.hasRetry()) {
                this.registry.counter("ft.retry.retries.total", this.methodTag).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_VALUE_RETURNED).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_VALUE_RETURNED).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED).getCount();
                this.registry.counter("ft.retry.calls.total", this.methodTag, MetricConstants.RETRIED_TRUE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED).getCount();
            }
            if (operation.hasTimeout()) {
                this.registry.counter("ft.timeout.calls.total", this.methodTag, MetricConstants.TIMED_OUT_TRUE).getCount();
                this.registry.counter("ft.timeout.calls.total", this.methodTag, MetricConstants.TIMED_OUT_FALSE).getCount();
                this.registry.histogram(MetricConstants.TIMEOUT_EXECUTION_DURATION_METADATA, this.methodTag).getCount();
            }
            if (operation.hasCircuitBreaker()) {
                this.registry.counter("ft.circuitbreaker.calls.total", this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_SUCCESS).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_FAILURE).getCount();
                this.registry.counter("ft.circuitbreaker.calls.total", this.methodTag, MetricConstants.CIRCUIT_BREAKER_RESULT_CB_OPEN).getCount();
                this.registry.counter("ft.circuitbreaker.opened.total", this.methodTag).getCount();
            }
            if (operation.hasBulkhead()) {
                this.registry.counter("ft.bulkhead.calls.total", this.methodTag, MetricConstants.BULKHEAD_RESULT_ACCEPTED).getCount();
                this.registry.counter("ft.bulkhead.calls.total", this.methodTag, MetricConstants.BULKHEAD_RESULT_REJECTED).getCount();
                this.registry.histogram(MetricConstants.BULKHEAD_RUNNING_DURATION_METADATA, this.methodTag).getCount();
                if (specCompatibility.isOperationTrulyOrPseudoAsynchronous(operation)) {
                    this.registry.histogram(MetricConstants.BULKHEAD_WAITING_DURATION_METADATA, this.methodTag).getCount();
                }
            }
        }

        private void registerGauge(Supplier<Long> supplier, String name, String unit, Tag ... tags) {
            Metadata metadata = Metadata.builder().withName(name).withType(MetricType.GAUGE).withUnit(unit).build();
            this.registry.gauge(metadata, supplier, tags);
        }

        @Override
        public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
            Tag resultTag;
            Tag tag = resultTag = succeeded ? MetricConstants.RESULT_VALUE_RETURNED : MetricConstants.RESULT_EXCEPTION_THROWN;
            Tag fallbackTag = fallbackDefined ? (fallbackApplied ? MetricConstants.FALLBACK_APPLIED : MetricConstants.FALLBACK_NOT_APPLIED) : MetricConstants.FALLBACK_NOT_DEFINED;
            this.registry.counter("ft.invocations.total", this.methodTag, resultTag, fallbackTag).inc();
        }

        @Override
        public void retryAttempted() {
            this.registry.counter("ft.retry.retries.total", this.methodTag).inc();
        }

        @Override
        public void retryValueReturned(boolean retried) {
            this.registry.counter("ft.retry.calls.total", this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_VALUE_RETURNED).inc();
        }

        @Override
        public void retryExceptionNotRetryable(boolean retried) {
            this.registry.counter("ft.retry.calls.total", this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_EXCEPTION_NOT_RETRYABLE).inc();
        }

        @Override
        public void retryMaxRetriesReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_RETRIES_REACHED).inc();
        }

        @Override
        public void retryMaxDurationReached(boolean retried) {
            this.registry.counter("ft.retry.calls.total", this.methodTag, retried ? MetricConstants.RETRIED_TRUE : MetricConstants.RETRIED_FALSE, MetricConstants.RETRY_RESULT_MAX_DURATION_REACHED).inc();
        }

        @Override
        public void timeoutFinished(boolean timedOut, long time) {
            this.registry.counter("ft.timeout.calls.total", this.methodTag, timedOut ? MetricConstants.TIMED_OUT_TRUE : MetricConstants.TIMED_OUT_FALSE).inc();
            this.registry.histogram(MetricConstants.TIMEOUT_EXECUTION_DURATION_METADATA, this.methodTag).update(time);
        }

        @Override
        public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
            Tag circuitBreakerResultTag = null;
            switch (result) {
                case SUCCESS: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_SUCCESS;
                    break;
                }
                case FAILURE: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_FAILURE;
                    break;
                }
                case PREVENTED: {
                    circuitBreakerResultTag = MetricConstants.CIRCUIT_BREAKER_RESULT_CB_OPEN;
                }
            }
            this.registry.counter("ft.circuitbreaker.calls.total", this.methodTag, circuitBreakerResultTag).inc();
        }

        @Override
        public void circuitBreakerMovedToOpen() {
            this.registry.counter("ft.circuitbreaker.opened.total", this.methodTag).inc();
        }

        @Override
        public void registerCircuitBreakerTimeSpentInClosed(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_CLOSED);
        }

        @Override
        public void registerCircuitBreakerTimeSpentInOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_OPEN);
        }

        @Override
        public void registerCircuitBreakerTimeSpentInHalfOpen(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.circuitbreaker.state.total", "nanoseconds", this.methodTag, MetricConstants.CIRCUIT_BREAKER_STATE_HALF_OPEN);
        }

        @Override
        public void bulkheadDecisionMade(boolean accepted) {
            Tag bulkheadResultTag = accepted ? MetricConstants.BULKHEAD_RESULT_ACCEPTED : MetricConstants.BULKHEAD_RESULT_REJECTED;
            this.registry.counter("ft.bulkhead.calls.total", this.methodTag, bulkheadResultTag).inc();
        }

        @Override
        public void registerBulkheadExecutionsRunning(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsRunning", "none", this.methodTag);
        }

        @Override
        public void registerBulkheadExecutionsWaiting(Supplier<Long> supplier) {
            this.registerGauge(supplier, "ft.bulkhead.executionsWaiting", "none", this.methodTag);
        }

        @Override
        public void updateBulkheadRunningDuration(long time) {
            this.registry.histogram(MetricConstants.BULKHEAD_RUNNING_DURATION_METADATA, this.methodTag).update(time);
        }

        @Override
        public void updateBulkheadWaitingDuration(long time) {
            this.registry.histogram(MetricConstants.BULKHEAD_WAITING_DURATION_METADATA, this.methodTag).update(time);
        }
    }
}

