/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.APIKeyHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public class APIKeyHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements APIKeyHandler {
    private Type source = Type.HEADER;
    private String value = "X-API-KEY";

    public APIKeyHandlerImpl(AuthenticationProvider authProvider) {
        super(authProvider);
    }

    @Override
    public APIKeyHandler header(String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException("'headerName' cannot be null");
        }
        this.source = Type.HEADER;
        this.value = headerName;
        return this;
    }

    @Override
    public APIKeyHandler parameter(String paramName) {
        if (paramName == null) {
            throw new IllegalArgumentException("'paramName' cannot be null");
        }
        this.source = Type.PARAMETER;
        this.value = paramName;
        return this;
    }

    @Override
    public APIKeyHandler cookie(String cookieName) {
        if (cookieName == null) {
            throw new IllegalArgumentException("'cookieName' cannot be null");
        }
        this.source = Type.COOKIE;
        this.value = cookieName;
        return this;
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        switch (this.source) {
            case HEADER: {
                MultiMap headers = context.request().headers();
                if (headers == null || !headers.contains(this.value)) break;
                this.authProvider.authenticate(new TokenCredentials(headers.get(this.value)), (AsyncResult<User> authn) -> {
                    if (authn.failed()) {
                        handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                    } else {
                        handler.handle((AsyncResult<User>)authn);
                    }
                });
                return;
            }
            case PARAMETER: {
                MultiMap params = context.request().params();
                if (params == null || !params.contains(this.value)) break;
                this.authProvider.authenticate(new TokenCredentials(params.get(this.value)), (AsyncResult<User> authn) -> {
                    if (authn.failed()) {
                        handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                    } else {
                        handler.handle((AsyncResult<User>)authn);
                    }
                });
                return;
            }
            case COOKIE: {
                Cookie cookie = context.request().getCookie(this.value);
                if (cookie == null) break;
                this.authProvider.authenticate(new TokenCredentials(cookie.getValue()), (AsyncResult<User> authn) -> {
                    if (authn.failed()) {
                        handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                    } else {
                        handler.handle((AsyncResult<User>)authn);
                    }
                });
                return;
            }
        }
        handler.handle(Future.failedFuture(UNAUTHORIZED));
    }

    static enum Type {
        HEADER,
        PARAMETER,
        COOKIE;

    }
}

