/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfiguration;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;

public class ConnectionPoolConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ConnectionPoolConfiguration> {
    private ExhaustedAction exhaustedAction = ExhaustedAction.WAIT;
    private int maxActive = -1;
    private long maxWait = -1L;
    private int minIdle = 1;
    private long minEvictableIdleTime = 1800000L;
    private int maxPendingRequests = 5;

    ConnectionPoolConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ConnectionPoolConfigurationBuilder exhaustedAction(ExhaustedAction exhaustedAction) {
        this.exhaustedAction = exhaustedAction;
        return this;
    }

    public ExhaustedAction exhaustedAction() {
        return this.exhaustedAction;
    }

    public ConnectionPoolConfigurationBuilder maxActive(int maxActive) {
        this.maxActive = maxActive;
        return this;
    }

    public int maxActive() {
        return this.maxActive;
    }

    public ConnectionPoolConfigurationBuilder maxWait(long maxWait) {
        this.maxWait = maxWait;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minIdle(int minIdle) {
        this.minIdle = minIdle;
        return this;
    }

    public ConnectionPoolConfigurationBuilder minEvictableIdleTime(long minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
        return this;
    }

    public ConnectionPoolConfigurationBuilder maxPendingRequests(int maxPendingRequests) {
        this.maxPendingRequests = maxPendingRequests;
        return this;
    }

    public ConnectionPoolConfigurationBuilder withPoolProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        this.exhaustedAction(typed.getEnumProperty("infinispan.client.hotrod.connection_pool.exhausted_action", ExhaustedAction.class, ExhaustedAction.values()[typed.getIntProperty("whenExhaustedAction", this.exhaustedAction.ordinal(), true)], true));
        this.maxActive(typed.getIntProperty("infinispan.client.hotrod.connection_pool.max_active", typed.getIntProperty("maxActive", this.maxActive, true), true));
        this.maxWait(typed.getLongProperty("infinispan.client.hotrod.connection_pool.max_wait", typed.getLongProperty("maxWait", this.maxWait, true), true));
        this.minIdle(typed.getIntProperty("infinispan.client.hotrod.connection_pool.min_idle", typed.getIntProperty("minIdle", this.minIdle, true), true));
        this.minEvictableIdleTime(typed.getLongProperty("infinispan.client.hotrod.connection_pool.min_evictable_idle_time", typed.getLongProperty("minEvictableIdleTimeMillis", this.minEvictableIdleTime, true), true));
        this.maxPendingRequests(typed.getIntProperty("infinispan.client.hotrod.connection_pool.max_pending_requests", typed.getIntProperty("maxPendingRequests", this.maxPendingRequests, true), true));
        return this;
    }

    @Override
    public ConnectionPoolConfiguration create() {
        return new ConnectionPoolConfiguration(this.exhaustedAction, this.maxActive, this.maxWait, this.minIdle, this.minEvictableIdleTime, this.maxPendingRequests);
    }

    public ConnectionPoolConfigurationBuilder read(ConnectionPoolConfiguration template) {
        this.exhaustedAction = template.exhaustedAction();
        this.maxActive = template.maxActive();
        this.maxWait = template.maxWait();
        this.minIdle = template.minIdle();
        this.minEvictableIdleTime = template.minEvictableIdleTime();
        this.maxPendingRequests = template.maxPendingRequests();
        return this;
    }
}

