/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseImpl;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.BuiltResponseEntityNotBacked;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AsyncResponseConsumer {
    protected Map<Class<?>, Object> contextDataMap;
    protected ResourceMethodInvoker method;
    protected SynchronousDispatcher dispatcher;
    protected ResteasyAsynchronousResponse asyncResponse;
    protected boolean isComplete;

    public AsyncResponseConsumer(ResourceMethodInvoker method) {
        this.method = method;
        this.contextDataMap = ResteasyContext.getContextDataMap();
        this.dispatcher = (SynchronousDispatcher)this.contextDataMap.get(Dispatcher.class);
        HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
        this.asyncResponse = httpRequest.getAsyncContext().isSuspended() ? httpRequest.getAsyncContext().getAsyncResponse() : httpRequest.getAsyncContext().suspend();
    }

    public static AsyncResponseConsumer makeAsyncResponseConsumer(ResourceMethodInvoker method, AsyncResponseProvider<?> asyncResponseProvider) {
        return new CompletionStageResponseConsumer(method, asyncResponseProvider);
    }

    public static AsyncResponseConsumer makeAsyncResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
        if (method.isSse()) {
            return new AsyncGeneralStreamingSseResponseConsumer(method, asyncStreamProvider);
        }
        Stream stream = method.getMethod().getAnnotation(Stream.class);
        if (stream != null) {
            if (Stream.MODE.RAW.equals((Object)stream.value())) {
                return new AsyncRawStreamingResponseConsumer(method, asyncStreamProvider);
            }
            return new AsyncGeneralStreamingSseResponseConsumer(method, asyncStreamProvider);
        }
        return new AsyncStreamCollectorResponseConsumer(method, asyncStreamProvider);
    }

    protected void doComplete() {
        this.asyncResponse.complete();
    }

    public final synchronized void complete(Throwable t) {
        if (!this.isComplete) {
            this.isComplete = true;
            this.doComplete();
            this.asyncResponse.completionCallbacks(t);
            ResteasyContext.removeContextDataLevel();
        }
    }

    protected void internalResume(Object entity, Consumer<Throwable> onComplete) {
        try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
            HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
            HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
            BuiltResponse builtResponse = this.createResponse(entity, httpRequest);
            try {
                this.sendBuiltResponse(builtResponse, httpRequest, httpResponse, e -> {
                    if (e != null) {
                        this.exceptionWhileResuming((Throwable)e);
                    }
                    onComplete.accept((Throwable)e);
                });
            }
            catch (Throwable e2) {
                this.exceptionWhileResuming(e2);
                onComplete.accept(e2);
            }
        }
    }

    private void exceptionWhileResuming(Throwable e) {
        try {
            this.internalResume(e, (Throwable t) -> {});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.complete(e);
    }

    protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) throws IOException {
        boolean sendHeaders = this.sendHeaders();
        ServerResponseWriter.writeNomapResponse(builtResponse, httpRequest, httpResponse, this.dispatcher.getProviderFactory(), onComplete, sendHeaders);
    }

    protected abstract boolean sendHeaders();

    protected void internalResume(Throwable t, Consumer<Throwable> onComplete) {
        try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
            HttpRequest httpRequest = (HttpRequest)this.contextDataMap.get(HttpRequest.class);
            HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
            try {
                this.dispatcher.writeException(httpRequest, httpResponse, t, onComplete);
            }
            catch (Throwable t2) {
                this.dispatcher.unhandledAsynchronousException(httpResponse, t);
                onComplete.accept(t);
            }
        }
    }

    protected BuiltResponse createResponse(Object entity, HttpRequest httpRequest) {
        BuiltResponse builtResponse = null;
        if (entity == null) {
            builtResponse = (BuiltResponse)Response.noContent().build();
        } else if (entity instanceof BuiltResponse) {
            builtResponse = (BuiltResponse)entity;
        } else if (entity instanceof Response) {
            Response r = (Response)entity;
            Headers<Object> metadata = new Headers<Object>();
            metadata.putAll(r.getMetadata());
            builtResponse = new BuiltResponseEntityNotBacked(r.getStatus(), r.getStatusInfo().getReasonPhrase(), metadata, r.getEntity(), this.method.getMethodAnnotations());
        } else {
            if (this.method == null) {
                throw new IllegalStateException(Messages.MESSAGES.unknownMediaTypeResponseEntity());
            }
            BuiltResponse jaxrsResponse = (BuiltResponse)Response.ok(entity).build();
            Type unwrappedType = ((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
            Type newType = this.adaptGenericType(unwrappedType);
            jaxrsResponse.setGenericType(newType);
            jaxrsResponse.addMethodAnnotations(this.method.getMethodAnnotations());
            builtResponse = jaxrsResponse;
        }
        return builtResponse;
    }

    protected Type adaptGenericType(Type unwrappedType) {
        return unwrappedType;
    }

    public abstract void subscribe(Object var1);

    private static class AsyncGeneralStreamingSseResponseConsumer
    extends AsyncStreamResponseConsumer {
        private SseImpl sse = new SseImpl();
        private SseEventSink sseEventSink = ResteasyContext.getContextData(SseEventSink.class);
        private boolean onCompleteReceived;
        private volatile boolean sendingEvent;

        private AsyncGeneralStreamingSseResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected void doComplete() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            this.sseEventSink.close();
        }

        @Override
        protected void addNextElement(Object element) {
            super.addNextElement(element);
        }

        @Override
        public synchronized void onComplete() {
            this.onCompleteReceived = true;
            if (!this.sendingEvent) {
                super.onComplete();
            }
        }

        @Override
        protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) {
            ServerResponseWriter.setResponseMediaType(builtResponse, httpRequest, httpResponse, this.dispatcher.getProviderFactory(), this.method);
            MediaType elementType = null;
            if (builtResponse.getEntity() instanceof OutboundSseEvent) {
                OutboundSseEvent entity = (OutboundSseEvent)builtResponse.getEntity();
                elementType = entity.getMediaType();
            }
            MediaType contentType = null;
            Object o = httpResponse.getOutputHeaders().getFirst("Content-Type");
            if (o != null) {
                if (o instanceof String) {
                    contentType = MediaType.valueOf((String)o);
                } else if (o instanceof MediaType) {
                    contentType = (MediaType)o;
                } else {
                    throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
                }
                if (elementType == null) {
                    String et = contentType.getParameters().get("element-type");
                    elementType = et != null ? MediaType.valueOf(et) : MediaType.TEXT_PLAIN_TYPE;
                }
            } else {
                throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
            }
            OutboundSseEvent event = this.sse.newEventBuilder().mediaType(elementType).data(builtResponse.getEntityClass(), builtResponse.getEntity()).build();
            if ("application".equals(contentType.getType()) && "x-stream-general".equals(contentType.getSubtype()) && event instanceof OutboundSseEventImpl) {
                ((OutboundSseEventImpl)event).setEscape(true);
            }
            this.sendingEvent = true;
            try {
                this.sseEventSink.send(event).whenComplete((val, ex) -> {
                    AsyncGeneralStreamingSseResponseConsumer asyncGeneralStreamingSseResponseConsumer = this;
                    synchronized (asyncGeneralStreamingSseResponseConsumer) {
                        this.sendingEvent = false;
                        if (this.onCompleteReceived) {
                            super.onComplete();
                        } else if (ex != null) {
                            this.complete((Throwable)ex);
                            onComplete.accept((Throwable)ex);
                        } else {
                            this.subscription.request(1L);
                            onComplete.accept((Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception x) {
                this.complete(x);
                onComplete.accept(x);
            }
        }

        @Override
        protected boolean sendHeaders() {
            return false;
        }
    }

    private static class AsyncStreamCollectorResponseConsumer
    extends AsyncStreamResponseConsumer {
        private List<Object> collector = new ArrayList<Object>();

        AsyncStreamCollectorResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected boolean sendHeaders() {
            return true;
        }

        @Override
        protected void addNextElement(Object element) {
            this.collector.add(element);
            this.subscription.request(1L);
        }

        @Override
        public void onComplete() {
            this.internalResume(this.collector, (Throwable t) -> this.complete((Throwable)t));
        }

        @Override
        protected Type adaptGenericType(final Type unwrappedType) {
            return new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{unwrappedType};
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }

                @Override
                public Type getRawType() {
                    return List.class;
                }
            };
        }
    }

    private static class AsyncRawStreamingResponseConsumer
    extends AsyncStreamResponseConsumer {
        private boolean sentEntity;
        private boolean onCompleteReceived;
        private volatile boolean sendingEvent;

        AsyncRawStreamingResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method, asyncStreamProvider);
        }

        @Override
        protected void sendBuiltResponse(BuiltResponse builtResponse, HttpRequest httpRequest, HttpResponse httpResponse, Consumer<Throwable> onComplete) throws IOException {
            Stream stream;
            ServerResponseWriter.setResponseMediaType(builtResponse, httpRequest, httpResponse, this.dispatcher.getProviderFactory(), this.method);
            boolean resetMediaType = false;
            String mediaTypeString = builtResponse.getHeaderString("Content-Type");
            if (mediaTypeString == null) {
                mediaTypeString = "application/octet-stream";
                resetMediaType = true;
            }
            MediaType mediaType = MediaType.valueOf(mediaTypeString);
            Stream[] streams = (Stream[])this.method.getMethod().getAnnotationsByType(Stream.class);
            if (streams.length > 0 && (stream = streams[0]).includeStreaming()) {
                HashMap<String, String> map = new HashMap<String, String>(mediaType.getParameters());
                map.put("streaming", "true");
                mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), map);
                resetMediaType = true;
            }
            if (resetMediaType) {
                MultivaluedTreeMap<String, Object> headerMap = new MultivaluedTreeMap<String, Object>();
                headerMap.putAll((Map<String, Object>)builtResponse.getHeaders());
                headerMap.remove("Content-Type");
                headerMap.add("Content-Type", mediaType);
                builtResponse.setMetadata(headerMap);
            }
            super.sendBuiltResponse(builtResponse, httpRequest, httpResponse, onComplete);
            this.sentEntity = true;
        }

        @Override
        protected void addNextElement(Object element) {
            this.sendingEvent = true;
            this.internalResume(element, (Throwable t) -> {
                AsyncRawStreamingResponseConsumer asyncRawStreamingResponseConsumer = this;
                synchronized (asyncRawStreamingResponseConsumer) {
                    this.sendingEvent = false;
                    if (this.onCompleteReceived) {
                        super.onComplete();
                    } else if (t != null) {
                        this.complete((Throwable)t);
                    } else {
                        this.subscription.request(1L);
                    }
                }
            });
        }

        @Override
        public synchronized void onComplete() {
            this.onCompleteReceived = true;
            if (!this.sendingEvent) {
                super.onComplete();
            }
        }

        @Override
        protected boolean sendHeaders() {
            return !this.sentEntity;
        }
    }

    private static abstract class AsyncStreamResponseConsumer
    extends AsyncResponseConsumer
    implements Subscriber<Object> {
        protected Subscription subscription;
        private AsyncStreamProvider<?> asyncStreamProvider;

        AsyncStreamResponseConsumer(ResourceMethodInvoker method, AsyncStreamProvider<?> asyncStreamProvider) {
            super(method);
            this.asyncStreamProvider = asyncStreamProvider;
        }

        @Override
        protected void doComplete() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            super.doComplete();
        }

        @Override
        public void onComplete() {
            this.complete(null);
        }

        @Override
        public void onError(Throwable t) {
            this.internalResume(t, (Throwable x) -> this.complete(t));
        }

        protected void addNextElement(Object element) {
            this.internalResume(element, (Throwable t) -> {
                if (t != null) {
                    this.complete((Throwable)t);
                }
            });
        }

        @Override
        public void onNext(Object v) {
            this.addNextElement(v);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void subscribe(Object rtn) {
            Publisher publisher = this.asyncStreamProvider.toAsyncStream(rtn);
            publisher.subscribe(this);
        }
    }

    private static class CompletionStageResponseConsumer
    extends AsyncResponseConsumer
    implements BiConsumer<Object, Throwable> {
        private AsyncResponseProvider<?> asyncResponseProvider;

        CompletionStageResponseConsumer(ResourceMethodInvoker method, AsyncResponseProvider<?> asyncResponseProvider) {
            super(method);
            this.asyncResponseProvider = asyncResponseProvider;
        }

        @Override
        protected boolean sendHeaders() {
            return true;
        }

        @Override
        public void accept(Object t, Throwable u) {
            if (t != null || u == null) {
                this.internalResume(t, (Throwable x) -> this.complete(null));
            } else {
                if (u instanceof CompletionException) {
                    u = u.getCause();
                }
                Throwable throwable = u;
                this.internalResume(throwable, (Throwable x) -> this.complete(throwable));
            }
        }

        @Override
        public void subscribe(Object rtn) {
            CompletionStage stage = this.asyncResponseProvider.toCompletionStage(rtn);
            stage.whenComplete(this);
        }
    }
}

