/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLTargetValue;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public class KiePMMLTarget
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = -6336733489238275499L;
    private final TargetField targetField;
    private final List<KiePMMLTargetValue> targetValues;

    private KiePMMLTarget(String name, List<KiePMMLExtension> extensions, TargetField targetField) {
        super(name, extensions);
        this.targetField = targetField;
        this.targetValues = targetField.getTargetValues() != null ? targetField.getTargetValues().stream().map(targetValue -> (KiePMMLTargetValue)KiePMMLTargetValue.builder(UUID.randomUUID().toString(), Collections.emptyList(), targetValue).build()).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, TargetField targetField) {
        return new Builder(name, extensions, targetField);
    }

    public Object modifyPrediction(Object prediction) {
        if (!(prediction instanceof Number)) {
            return prediction;
        }
        double predictionDouble = (Double)prediction;
        Number toReturn = this.applyMin(predictionDouble);
        toReturn = this.applyMax((double)toReturn);
        toReturn = this.applyRescaleFactor((double)toReturn);
        toReturn = this.applyRescaleConstant((double)toReturn);
        toReturn = this.applyCastInteger((double)toReturn);
        return toReturn;
    }

    Double applyMin(double predictionDouble) {
        return this.targetField.getMin() != null ? Math.max(this.targetField.getMin(), predictionDouble) : predictionDouble;
    }

    Double applyMax(double predictionDouble) {
        return this.targetField.getMax() != null ? Math.min(this.targetField.getMax(), predictionDouble) : predictionDouble;
    }

    Double applyRescaleFactor(double predictionDouble) {
        return predictionDouble * this.targetField.getRescaleFactor();
    }

    Double applyRescaleConstant(double predictionDouble) {
        return predictionDouble + this.targetField.getRescaleConstant();
    }

    Number applyCastInteger(double predictionDouble) {
        return this.targetField.getCastInteger() != null ? (double)this.targetField.getCastInteger().getScaledValue(predictionDouble).intValue() : predictionDouble;
    }

    public String getField() {
        return this.targetField.getField();
    }

    public List<KiePMMLTargetValue> getTargetValues() {
        return Collections.unmodifiableList(this.targetValues);
    }

    public OP_TYPE getOpType() {
        return this.targetField.getOpType();
    }

    public CAST_INTEGER getCastInteger() {
        return this.targetField.getCastInteger();
    }

    public Double getMin() {
        return this.targetField.getMin();
    }

    public Double getMax() {
        return this.targetField.getMax();
    }

    public double getRescaleConstant() {
        return this.targetField.getRescaleConstant();
    }

    public double getRescaleFactor() {
        return this.targetField.getRescaleFactor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KiePMMLTarget that = (KiePMMLTarget)o;
        return Objects.equals(this.targetField, that.targetField);
    }

    public int hashCode() {
        return Objects.hash(this.targetField);
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLTarget.class.getSimpleName() + "[", "]").add("targetField=" + this.targetField).add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLTarget> {
        private Builder(String name, List<KiePMMLExtension> extensions, TargetField targetField) {
            super("Target-", () -> new KiePMMLTarget(name, extensions, targetField));
        }
    }
}

