/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigSourceFactoryProvider;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ConfigUtils {
    static final String UUID_KEY = "quarkus.uuid";
    public static final String QUARKUS_RUNTIME_CONFIG_DEFAULTS_PROPERTIES = "quarkus-runtime-config-defaults.properties";

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, true, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, false, addDiscovered, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean bootstrap, boolean addDiscovered, LaunchMode launchMode) {
        SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        builder.forClassLoader(classLoader);
        builder.withSources(new ApplicationPropertiesConfigSourceLoader.InFileSystem());
        builder.withSources(new ApplicationPropertiesConfigSourceLoader.InClassPath());
        if (launchMode.isDevOrTest() && (runTime || bootstrap)) {
            builder.withSources(new RuntimeOverrideConfigSource(classLoader));
        }
        if (runTime) {
            builder.addDefaultSources();
            builder.withDefaultValue(UUID_KEY, UUID.randomUUID().toString());
            builder.withSources(new DotEnvConfigSourceProvider());
        } else {
            ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
            sources.addAll(PropertiesConfigSourceProvider.classPathSources("META-INF/microprofile-config.properties", classLoader));
            sources.addAll((Collection<ConfigSource>)new BuildTimeDotEnvConfigSourceProvider().getConfigSources(classLoader));
            sources.add(new BuildTimeEnvConfigSource());
            sources.add(new BuildTimeSysPropConfigSource());
            builder.withSources(sources);
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
        }
        if (runTime || bootstrap) {
            Map<String, String> runtimeDefaults = ConfigUtils.loadRuntimeDefaultValues();
            builder.withSources(new PropertiesConfigSource(runtimeDefaults, "Runtime Defaults", -2147483598));
        }
        return builder;
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withDefaultValue("smallrye.config.profile", ProfileManager.getActiveProfile());
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> relocations = new HashMap<String, String>();
                relocations.put("smallrye.config.locations", "quarkus.config.locations");
                relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
                ConfigValue profileValue = context.proceed("smallrye.config.profile");
                if (profileValue != null) {
                    List<String> profiles = ProfileConfigSourceInterceptor.convertProfile(profileValue.getValue());
                    for (String profile : profiles) {
                        relocations.put("%" + profile + ".smallrye.config.profile.parent", "%" + profile + ".quarkus.config.profile.parent");
                    }
                }
                return new RelocateConfigSourceInterceptor(relocations);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3195);
            }
        });
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory(){

            @Override
            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> fallbacks = new HashMap<String, String>();
                fallbacks.put("quarkus.config.locations", "smallrye.config.locations");
                fallbacks.put("quarkus.config.profile.parent", "smallrye.config.profile.parent");
                return new FallbackConfigSourceInterceptor(fallbacks);
            }

            @Override
            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        });
        builder.addDefaultInterceptors();
        builder.addDiscoveredInterceptors();
        builder.addDiscoveredConverters();
        builder.addDiscoveredValidator();
        return builder;
    }

    public static SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder, List<ConfigBuilder> configBuilders) {
        configBuilders.sort(Comparator.comparing(ConfigBuilder::priority));
        for (ConfigBuilder configBuilder : configBuilders) {
            builder = configBuilder.configBuilder(builder);
            if (builder != null) continue;
            throw new ConfigurationException(configBuilder.getClass().getName() + " returned a null builder");
        }
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable<ConfigSource> sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(source);
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    public static void addSourceFactoryProvider(SmallRyeConfigBuilder builder, ConfigSourceFactoryProvider provider) {
        builder.withSources(provider.getConfigSourceFactory(Thread.currentThread().getContextClassLoader()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadRuntimeDefaultValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(QUARKUS_RUNTIME_CONFIG_DEFAULTS_PROPERTIES);){
            if (in == null) {
                HashMap<String, String> hashMap2 = values;
                return hashMap2;
            }
            Properties p = new Properties();
            p.load(in);
            for (String k : p.stringPropertyNames()) {
                if (values.containsKey(k)) continue;
                values.put(k, p.getProperty(k));
            }
            HashMap<String, String> hashMap = values;
            return hashMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addMapping(SmallRyeConfigBuilder builder, String mappingClass, String prefix) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            builder.withMapping(contextClassLoader.loadClass(mappingClass), prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ConfigProvider.getConfig().unwrap(SmallRyeConfig.class).isPropertyPresent(propertyName);
    }

    static class BuildTimeSysPropConfigSource
    extends SysPropConfigSource {
        BuildTimeSysPropConfigSource() {
        }

        @Override
        public String getName() {
            return "System properties";
        }

        @Override
        public Set<String> getPropertyNames() {
            return Collections.emptySet();
        }
    }

    static class BuildTimeDotEnvConfigSourceProvider
    extends DotEnvConfigSourceProvider {
        public BuildTimeDotEnvConfigSourceProvider() {
        }

        public BuildTimeDotEnvConfigSourceProvider(String location) {
            super(location);
        }

        @Override
        protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
            return new BuildTimeEnvConfigSource(ConfigSourceUtil.urlToMap(url), ordinal){

                @Override
                public String getName() {
                    return super.getName() + "[source=" + url + "]";
                }
            };
        }
    }

    static class BuildTimeEnvConfigSource
    extends EnvConfigSource {
        BuildTimeEnvConfigSource() {
        }

        BuildTimeEnvConfigSource(Map<String, String> propertyMap, int ordinal) {
            super(propertyMap, ordinal);
        }

        @Override
        public Set<String> getPropertyNames() {
            return Collections.emptySet();
        }

        @Override
        public String getName() {
            return "System environment";
        }
    }
}

