/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.api.FaultToleranceSpi;
import io.smallrye.faulttolerance.core.apiimpl.FaultToleranceImpl;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.timer.Timer;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CdiFaultToleranceSpi
implements FaultToleranceSpi {
    private Dependencies getDependencies() {
        return (Dependencies)CDI.current().select(Dependencies.class, new Annotation[0]).get();
    }

    @Override
    public boolean applies() {
        try {
            return this.getDependencies() != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public int priority() {
        return 1000;
    }

    @Override
    public <T, R> FaultTolerance.Builder<T, R> newBuilder(Function<FaultTolerance<T>, R> finisher) {
        Dependencies deps = this.getDependencies();
        return new FaultToleranceImpl.BuilderImpl<T, R>(deps.ftEnabled, deps.asyncExecutor(), deps.timer(), deps.eventLoop(), deps.cbMaintenance, false, null, finisher);
    }

    @Override
    public <T, R> FaultTolerance.Builder<T, R> newAsyncBuilder(Class<?> asyncType, Function<FaultTolerance<T>, R> finisher) {
        Dependencies deps = this.getDependencies();
        return new FaultToleranceImpl.BuilderImpl<T, R>(deps.ftEnabled, deps.asyncExecutor(), deps.timer(), deps.eventLoop(), deps.cbMaintenance, true, asyncType, finisher);
    }

    @Override
    public CircuitBreakerMaintenance circuitBreakerMaintenance() {
        return this.getDependencies().cbMaintenance;
    }

    @Singleton
    public static class Dependencies {
        @Inject
        @ConfigProperty(name="MP_Fault_Tolerance_NonFallback_Enabled", defaultValue="true")
        boolean ftEnabled;
        @Inject
        ExecutorHolder executorHolder;
        @Inject
        CircuitBreakerMaintenanceImpl cbMaintenance;

        ExecutorService asyncExecutor() {
            return this.executorHolder.getAsyncExecutor();
        }

        EventLoop eventLoop() {
            return this.executorHolder.getEventLoop();
        }

        Timer timer() {
            return this.executorHolder.getTimer();
        }
    }
}

