/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.locals;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

public class LocalContextMetadata {
    private final Context context;

    public LocalContextMetadata(Context context) {
        this.context = context;
    }

    public Context context() {
        return this.context;
    }

    public static <T> Uni<T> invokeOnMessageContext(Message<?> incoming, Function<Message<?>, T> function) {
        return LocalContextMetadata.invokeOnMessageContext(incoming, (Message<?> message, UniEmitter<? super T> emitter) -> {
            Object res;
            try {
                res = function.apply((Message<?>)message);
            }
            catch (Exception failure) {
                emitter.fail(failure);
                return;
            }
            emitter.complete(res);
        });
    }

    public static <T> Uni<T> invokeOnMessageContext(Message<?> incoming, BiConsumer<Message<?>, UniEmitter<? super T>> function) {
        Optional metadata;
        Optional<Object> optional = metadata = incoming != null ? incoming.getMetadata().get(LocalContextMetadata.class) : Optional.empty();
        if (metadata.isPresent()) {
            return Uni.createFrom().emitter(emitter -> {
                Context current = Vertx.currentContext();
                if (current != null && current == ((LocalContextMetadata)metadata.get()).context) {
                    try {
                        function.accept(incoming, (UniEmitter)emitter);
                    }
                    catch (Exception e) {
                        emitter.fail(e);
                    }
                    return;
                }
                ((LocalContextMetadata)metadata.get()).context.runOnContext(x -> {
                    try {
                        function.accept(incoming, (UniEmitter)emitter);
                    }
                    catch (Exception e) {
                        emitter.fail(e);
                    }
                });
            });
        }
        return Uni.createFrom().emitter(emitter -> function.accept(incoming, (UniEmitter)emitter));
    }
}

