/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler.impl;

import io.vertx.mutiny.core.Vertx;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.jobs.service.model.job.ManageableJobHandle;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.InternalSchedulerService;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.JobContext;
import org.kie.kogito.timer.JobHandle;
import org.kie.kogito.timer.TimerService;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.DefaultTimerJobFactoryManager;
import org.kie.kogito.timer.impl.TimerJobFactoryManager;
import org.kie.kogito.timer.impl.TimerJobInstance;

@ApplicationScoped
public class VertxTimerServiceScheduler
implements TimerService<ManageableJobHandle>,
InternalSchedulerService {
    protected TimerJobFactoryManager jobFactoryManager = DefaultTimerJobFactoryManager.instance;
    protected Vertx vertx;

    public VertxTimerServiceScheduler() {
        this.vertx = Vertx.vertx();
    }

    public VertxTimerServiceScheduler(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown() {
        this.vertx.close();
    }

    @Override
    public long getTimeToNextJob() {
        return 0L;
    }

    @Override
    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        return this.jobFactoryManager.getTimerJobInstances();
    }

    @Override
    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        this.jobFactoryManager = timerJobFactoryManager;
    }

    @Override
    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    @Override
    public ManageableJobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        return Optional.ofNullable(trigger.hasNextFireTime()).map(id -> new ManageableJobHandle(false)).map(jobHandle -> this.jobFactoryManager.createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, this)).map(jobInstance -> {
            this.internalSchedule((TimerJobInstance)jobInstance);
            return (ManageableJobHandle)jobInstance.getJobHandle();
        }).orElse(null);
    }

    @Override
    public boolean removeJob(ManageableJobHandle jobHandle) {
        return this.vertx.cancelTimer(jobHandle.getId());
    }

    @Override
    public void internalSchedule(TimerJobInstance timerJobInstance) {
        Trigger trigger = timerJobInstance.getTrigger();
        if (trigger.hasNextFireTime() == null) {
            return;
        }
        long then = trigger.hasNextFireTime().getTime();
        ZonedDateTime now = DateUtil.now();
        long delay = this.calculateDelay(then, now);
        ManageableJobHandle handle = (ManageableJobHandle)timerJobInstance.getJobHandle();
        long scheduledId = this.vertx.setTimer(delay, i -> timerJobInstance.getJob().execute(timerJobInstance.getJobContext()));
        handle.setId(scheduledId);
        handle.setScheduledTime(now);
    }

    private Long calculateDelay(long then, ZonedDateTime now) {
        return Optional.of(now).map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli).filter(n -> then > n).map(n -> then - n).orElse(1L);
    }

    public Vertx getVertx() {
        return this.vertx;
    }
}

