/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Consumer;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class BackChannelLogoutHandler {
    private static final Logger LOG = Logger.getLogger(BackChannelLogoutHandler.class);
    @Inject
    DefaultTenantConfigResolver resolver;
    private final OidcConfig oidcConfig;

    public BackChannelLogoutHandler(OidcConfig oidcConfig) {
        this.oidcConfig = oidcConfig;
    }

    public void setup(@Observes Router router) {
        this.addRoute(router, this.oidcConfig.defaultTenant);
        for (OidcTenantConfig oidcTenantConfig : this.oidcConfig.namedTenants.values()) {
            this.addRoute(router, oidcTenantConfig);
        }
    }

    private void addRoute(Router router, OidcTenantConfig oidcTenantConfig) {
        if (oidcTenantConfig.isTenantEnabled() && oidcTenantConfig.logout.backchannel.path.isPresent()) {
            router.route(oidcTenantConfig.logout.backchannel.path.get()).handler(new RouteHandler(oidcTenantConfig));
        }
    }

    class RouteHandler
    implements Handler<RoutingContext> {
        private final OidcTenantConfig oidcTenantConfig;

        RouteHandler(OidcTenantConfig oidcTenantConfig) {
            this.oidcTenantConfig = oidcTenantConfig;
        }

        @Override
        public void handle(final RoutingContext context) {
            LOG.debugf("Back channel logout request for the tenant %s received", (Object)this.oidcTenantConfig.getTenantId().get());
            final TenantConfigContext tenantContext = this.getTenantConfigContext(context);
            if (tenantContext == null) {
                LOG.debugf("Tenant configuration for the tenant %s is not available or does not match the backchannel logout path", (Object)this.oidcTenantConfig.getTenantId().get());
            }
            if (OidcUtils.isFormUrlEncodedRequest(context)) {
                OidcUtils.getFormUrlEncodedData(context).subscribe().with(new Consumer<MultiMap>(){

                    @Override
                    public void accept(MultiMap form) {
                        String encodedLogoutToken = form.get("logout_token");
                        if (encodedLogoutToken == null) {
                            LOG.debug("Back channel logout token is missing");
                            context.response().setStatusCode(400);
                        } else {
                            try {
                                TokenVerificationResult result = tenantContext.provider.verifyLogoutJwtToken(encodedLogoutToken);
                                if (RouteHandler.this.verifyLogoutTokenClaims(result)) {
                                    BackChannelLogoutHandler.this.resolver.getBackChannelLogoutTokens().put(RouteHandler.this.oidcTenantConfig.tenantId.get(), result);
                                    context.response().setStatusCode(200);
                                } else {
                                    context.response().setStatusCode(400);
                                }
                            }
                            catch (InvalidJwtException e) {
                                LOG.debug("Back channel logout token is invalid");
                                context.response().setStatusCode(400);
                            }
                        }
                        context.response().end();
                    }
                });
            } else {
                LOG.debug("HTTP POST and " + HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString() + " content type must be used with the Back channel logout request");
                context.response().setStatusCode(400);
                context.response().end();
            }
        }

        private boolean verifyLogoutTokenClaims(TokenVerificationResult result) {
            JsonObject events = result.localVerificationResult.getJsonObject("events");
            if (events == null || events.getJsonObject("http://schemas.openid.net/event/backchannel-logout") == null) {
                LOG.debug("Back channel logout token does not have a valid 'events' claim");
                return false;
            }
            if (!result.localVerificationResult.containsKey(Claims.sub.name()) && !result.localVerificationResult.containsKey("sid")) {
                LOG.debug("Back channel logout token does not have 'sub' or 'sid' claim");
                return false;
            }
            if (result.localVerificationResult.containsKey(Claims.nonce.name())) {
                LOG.debug("Back channel logout token must not contain 'nonce' claim");
                return false;
            }
            return true;
        }

        private TenantConfigContext getTenantConfigContext(RoutingContext context) {
            String requestPath = context.request().path();
            if (this.isMatchingTenant(requestPath, BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getDefaultTenant())) {
                return BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getDefaultTenant();
            }
            for (TenantConfigContext tenant : BackChannelLogoutHandler.this.resolver.getTenantConfigBean().getStaticTenantsConfig().values()) {
                if (!this.isMatchingTenant(requestPath, tenant)) continue;
                return tenant;
            }
            return null;
        }

        private boolean isMatchingTenant(String requestPath, TenantConfigContext tenant) {
            return tenant.oidcConfig.isTenantEnabled() && tenant.oidcConfig.getTenantId().get().equals(this.oidcTenantConfig.getTenantId().get()) && requestPath.equals(tenant.oidcConfig.logout.backchannel.path.orElse(null));
        }
    }
}

