/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusExistingCircuitBreakerNames;
import io.quarkus.smallrye.faulttolerance.runtime.QuarkusFaultToleranceOperationProvider;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Recorder
public class SmallRyeFaultToleranceRecorder {
    public void createFaultToleranceOperation(List<FaultToleranceMethod> ftMethods) {
        ArrayList<Exception> allExceptions = new ArrayList<Exception>();
        HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation> operationCache = new HashMap<QuarkusFaultToleranceOperationProvider.CacheKey, FaultToleranceOperation>(ftMethods.size());
        for (FaultToleranceMethod ftMethod : ftMethods) {
            FaultToleranceOperation operation = FaultToleranceOperation.create(ftMethod);
            try {
                operation.validate();
                QuarkusFaultToleranceOperationProvider.CacheKey cacheKey = new QuarkusFaultToleranceOperationProvider.CacheKey(ftMethod.beanClass, ftMethod.method.reflect());
                operationCache.put(cacheKey, operation);
            }
            catch (NoSuchMethodException | FaultToleranceDefinitionException exception) {
                allExceptions.add(exception);
            }
        }
        if (!allExceptions.isEmpty()) {
            if (allExceptions.size() == 1) {
                Throwable error = (Throwable)allExceptions.get(0);
                if (error instanceof DeploymentException) {
                    throw (DeploymentException)error;
                }
                throw new DeploymentException((Throwable)allExceptions.get(0));
            }
            StringBuilder message = new StringBuilder("Found " + allExceptions.size() + " deployment problems: ");
            int idx = 1;
            for (Throwable throwable : allExceptions) {
                message.append("\n").append("[").append(idx++).append("] ").append(throwable.getMessage());
            }
            DeploymentException deploymentException = new DeploymentException(message.toString());
            for (Throwable throwable : allExceptions) {
                deploymentException.addSuppressed(throwable);
            }
            throw deploymentException;
        }
        Arc.container().instance(QuarkusFaultToleranceOperationProvider.class, new Annotation[0]).get().init(operationCache);
    }

    public void initExistingCircuitBreakerNames(Set<String> names) {
        Arc.container().instance(QuarkusExistingCircuitBreakerNames.class, new Annotation[0]).get().init(names);
    }
}

