/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.vertx.web.runtime.JsonArrayMulti;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiJsonArraySupport {
    private MultiJsonArraySupport() {
    }

    public static void subscribeVoid(Multi<Void> multi, RoutingContext rc) {
        MultiJsonArraySupport.subscribeString(multi.onItem().castTo(String.class), rc);
    }

    public static void subscribeString(Multi<String> multi, RoutingContext rc) {
        MultiJsonArraySupport.write(multi.map(new Function<String, Buffer>(){

            @Override
            public Buffer apply(String s) {
                return Buffer.buffer("\"" + s + "\"");
            }
        }), rc);
    }

    private static void write(Multi<Buffer> multi, final RoutingContext rc) {
        final HttpServerResponse response = rc.response();
        multi.subscribe().withSubscriber(new Subscriber<Buffer>(){
            Subscription upstream;

            @Override
            public void onSubscribe(Subscription subscription) {
                this.upstream = subscription;
                this.upstream.request(1L);
            }

            @Override
            public void onNext(Buffer item) {
                Buffer toBeWritten;
                if (response.bytesWritten() == 0L) {
                    response.setChunked(true);
                    MultiMap headers = response.headers();
                    if (headers.get("content-type") == null) {
                        headers.set("content-type", "application/json");
                    }
                    toBeWritten = Buffer.buffer("[").appendBuffer(item);
                } else {
                    toBeWritten = Buffer.buffer(",").appendBuffer(item);
                }
                response.write(toBeWritten, new Handler<AsyncResult<Void>>(){

                    @Override
                    public void handle(AsyncResult<Void> ar) {
                        MultiJsonArraySupport.onWriteDone(upstream, ar, rc);
                    }
                });
            }

            @Override
            public void onError(Throwable throwable) {
                rc.fail(throwable);
            }

            @Override
            public void onComplete() {
                MultiJsonArraySupport.completeJsonArray(response);
            }
        });
    }

    private static void onWriteDone(Subscription subscription, AsyncResult<Void> ar, RoutingContext rc) {
        if (ar.failed()) {
            rc.fail(ar.cause());
        } else {
            subscription.request(1L);
        }
    }

    public static void subscribeObject(Multi<Object> multi, RoutingContext rc) {
        MultiJsonArraySupport.write(multi.map(new Function<Object, Buffer>(){

            @Override
            public Buffer apply(Object item) {
                return Json.encodeToBuffer(item);
            }
        }), rc);
    }

    public static void fail(RoutingContext rc) {
        rc.fail(new Exception("Unsupported type"));
    }

    private static void completeJsonArray(HttpServerResponse response) {
        if (response.bytesWritten() == 0L) {
            MultiMap headers = response.headers();
            if (headers.get("content-type") == null) {
                headers.set("content-type", "application/json");
            }
            response.end("[]");
        } else {
            response.end("]");
        }
    }

    public static boolean isJsonArray(Multi<?> multi) {
        return multi instanceof JsonArrayMulti;
    }
}

