/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.CircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.api.CircuitBreakerMaintenance;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.api.FaultToleranceSpi;
import io.smallrye.faulttolerance.core.apiimpl.BasicCircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.core.apiimpl.BuilderEagerDependencies;
import io.smallrye.faulttolerance.core.apiimpl.BuilderLazyDependencies;
import io.smallrye.faulttolerance.core.apiimpl.FaultToleranceImpl;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.timer.Timer;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CdiFaultToleranceSpi
implements FaultToleranceSpi {
    private BuilderEagerDependencies eagerDependencies() {
        return (BuilderEagerDependencies)CDI.current().select(EagerDependencies.class, new Annotation[0]).get();
    }

    private BuilderLazyDependencies lazyDependencies() {
        return (BuilderLazyDependencies)CDI.current().select(LazyDependencies.class, new Annotation[0]).get();
    }

    @Override
    public boolean applies() {
        try {
            CDI.current();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    public int priority() {
        return 1000;
    }

    @Override
    public <T, R> FaultTolerance.Builder<T, R> newBuilder(Function<FaultTolerance<T>, R> finisher) {
        return new FaultToleranceImpl.BuilderImpl<T, R>(this.eagerDependencies(), this::lazyDependencies, null, finisher);
    }

    @Override
    public <T, R> FaultTolerance.Builder<T, R> newAsyncBuilder(Class<?> asyncType, Function<FaultTolerance<T>, R> finisher) {
        return new FaultToleranceImpl.BuilderImpl<T, R>(this.eagerDependencies(), this::lazyDependencies, asyncType, finisher);
    }

    @Override
    public CircuitBreakerMaintenance circuitBreakerMaintenance() {
        return this.eagerDependencies().cbMaintenance();
    }

    @Singleton
    public static class LazyDependencies
    implements BuilderLazyDependencies {
        @Inject
        @ConfigProperty(name="MP_Fault_Tolerance_NonFallback_Enabled", defaultValue="true")
        boolean ftEnabled;
        @Inject
        ExecutorHolder executorHolder;
        @Inject
        CircuitBreakerMaintenanceImpl cbMaintenance;

        @Override
        public boolean ftEnabled() {
            return this.ftEnabled;
        }

        @Override
        public ExecutorService asyncExecutor() {
            return this.executorHolder.getAsyncExecutor();
        }

        @Override
        public EventLoop eventLoop() {
            return this.executorHolder.getEventLoop();
        }

        @Override
        public Timer timer() {
            return this.executorHolder.getTimer();
        }
    }

    @Singleton
    public static class EagerDependencies
    implements BuilderEagerDependencies {
        @Inject
        CircuitBreakerMaintenanceImpl cbMaintenance;

        @Override
        public BasicCircuitBreakerMaintenanceImpl cbMaintenance() {
            return this.cbMaintenance;
        }
    }
}

