/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Unmanaged;
import javax.inject.Inject;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

@Dependent
public class DefaultFallbackHandlerProvider
implements FallbackHandlerProvider {
    @Inject
    BeanManager beanManager;

    @Override
    public <T> FallbackHandler<T> get(final FaultToleranceOperation operation) {
        if (operation.hasFallback()) {
            return new FallbackHandler<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T handle(ExecutionContext context) {
                    Unmanaged unmanaged = new Unmanaged(DefaultFallbackHandlerProvider.this.beanManager, operation.getFallback().value());
                    Unmanaged.UnmanagedInstance<FallbackHandler<?>> unmanagedInstance = unmanaged.newInstance();
                    FallbackHandler<?> handler = unmanagedInstance.produce().inject().postConstruct().get();
                    try {
                        Object obj = handler.handle(context);
                        return obj;
                    }
                    finally {
                        unmanagedInstance.preDestroy().dispose();
                    }
                }
            };
        }
        return null;
    }
}

