/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.AsynchronousConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

public final class AsynchronousConfigImpl
implements AsynchronousConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Asynchronous instance;
    private final boolean onMethod;

    private AsynchronousConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.asynchronous;
        this.onMethod = method.annotationsPresentDirectly.contains(Asynchronous.class);
    }

    public static AsynchronousConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronous == null) {
            return null;
        }
        if (!Config.isEnabled(Asynchronous.class, method.method)) {
            return null;
        }
        return new AsynchronousConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return this.method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Asynchronous.class;
    }

    @Override
    public boolean isOnMethod() {
        return this.onMethod;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Asynchronous/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Asynchronous/" + key;
    }
}

