/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface CircuitBreakerConfig
extends CircuitBreaker,
Config {
    @Override
    default public void validate() {
        String INVALID_CIRCUIT_BREAKER_ON = "Invalid @CircuitBreaker on ";
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + this.method() + ": delay shouldn't be lower than 0");
        }
        if (this.requestVolumeThreshold() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + this.method() + ": requestVolumeThreshold shouldn't be lower than 1");
        }
        if (this.failureRatio() < 0.0 || this.failureRatio() > 1.0) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + this.method() + ": failureRation should be between 0 and 1");
        }
        if (this.successThreshold() < 1) {
            throw new FaultToleranceDefinitionException("Invalid @CircuitBreaker on " + this.method() + ": successThreshold shouldn't be lower than 1");
        }
    }
}

