/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import java.time.Duration;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface RetryConfig
extends Retry,
Config {
    @Override
    default public void validate() {
        long delay;
        String INVALID_RETRY_ON = "Invalid @Retry on ";
        if (this.maxRetries() < -1) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + this.method() + ": maxRetries shouldn't be lower than -1");
        }
        if (this.delay() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + this.method() + ": delay shouldn't be lower than 0");
        }
        if (this.maxDuration() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + this.method() + ": maxDuration shouldn't be lower than 0");
        }
        long maxDuration = Duration.of(this.maxDuration(), this.durationUnit()).toMillis();
        if (maxDuration > 0L && maxDuration <= (delay = Duration.of(this.delay(), this.delayUnit()).toMillis())) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + this.method() + ": maxDuration should be greater than delay");
        }
        if (this.jitter() < 0L) {
            throw new FaultToleranceDefinitionException("Invalid @Retry on " + this.method() + ": jitter shouldn't be lower than 0");
        }
    }
}

