/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.RetryConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;

public final class RetryConfigImpl
implements RetryConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Retry instance;
    private final boolean onMethod;
    private Integer _maxRetries;
    private Long _delay;
    private ChronoUnit _delayUnit;
    private Long _maxDuration;
    private ChronoUnit _durationUnit;
    private Long _jitter;
    private ChronoUnit _jitterDelayUnit;
    private Class<? extends Throwable>[] _retryOn;
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retry;
        this.onMethod = method.annotationsPresentDirectly.contains(Retry.class);
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!io.smallrye.faulttolerance.autoconfig.Config.isEnabled(Retry.class, method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return this.beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return this.method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    @Override
    public boolean isOnMethod() {
        return this.onMethod;
    }

    @Override
    public int maxRetries() {
        if (this._maxRetries == null) {
            Config config = ConfigProvider.getConfig();
            this._maxRetries = this.onMethod ? (Integer)config.getOptionalValue(this.getConfigKeyForMethod("maxRetries"), Integer.TYPE).orElse(null) : (Integer)config.getOptionalValue(this.getConfigKeyForClass("maxRetries"), Integer.TYPE).orElse(null);
            if (this._maxRetries == null) {
                this._maxRetries = config.getOptionalValue("Retry/maxRetries", Integer.TYPE).orElse(null);
            }
            if (this._maxRetries == null) {
                this._maxRetries = this.instance.maxRetries();
            }
        }
        return this._maxRetries;
    }

    @Override
    public long delay() {
        if (this._delay == null) {
            Config config = ConfigProvider.getConfig();
            this._delay = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("delay"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("delay"), Long.TYPE).orElse(null);
            if (this._delay == null) {
                this._delay = config.getOptionalValue("Retry/delay", Long.TYPE).orElse(null);
            }
            if (this._delay == null) {
                this._delay = this.instance.delay();
            }
        }
        return this._delay;
    }

    @Override
    public ChronoUnit delayUnit() {
        if (this._delayUnit == null) {
            Config config = ConfigProvider.getConfig();
            this._delayUnit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("delayUnit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("delayUnit"), ChronoUnit.class).orElse(null);
            if (this._delayUnit == null) {
                this._delayUnit = config.getOptionalValue("Retry/delayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._delayUnit == null) {
                this._delayUnit = this.instance.delayUnit();
            }
        }
        return this._delayUnit;
    }

    @Override
    public long maxDuration() {
        if (this._maxDuration == null) {
            Config config = ConfigProvider.getConfig();
            this._maxDuration = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("maxDuration"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("maxDuration"), Long.TYPE).orElse(null);
            if (this._maxDuration == null) {
                this._maxDuration = config.getOptionalValue("Retry/maxDuration", Long.TYPE).orElse(null);
            }
            if (this._maxDuration == null) {
                this._maxDuration = this.instance.maxDuration();
            }
        }
        return this._maxDuration;
    }

    @Override
    public ChronoUnit durationUnit() {
        if (this._durationUnit == null) {
            Config config = ConfigProvider.getConfig();
            this._durationUnit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("durationUnit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("durationUnit"), ChronoUnit.class).orElse(null);
            if (this._durationUnit == null) {
                this._durationUnit = config.getOptionalValue("Retry/durationUnit", ChronoUnit.class).orElse(null);
            }
            if (this._durationUnit == null) {
                this._durationUnit = this.instance.durationUnit();
            }
        }
        return this._durationUnit;
    }

    @Override
    public long jitter() {
        if (this._jitter == null) {
            Config config = ConfigProvider.getConfig();
            this._jitter = this.onMethod ? (Long)config.getOptionalValue(this.getConfigKeyForMethod("jitter"), Long.TYPE).orElse(null) : (Long)config.getOptionalValue(this.getConfigKeyForClass("jitter"), Long.TYPE).orElse(null);
            if (this._jitter == null) {
                this._jitter = config.getOptionalValue("Retry/jitter", Long.TYPE).orElse(null);
            }
            if (this._jitter == null) {
                this._jitter = this.instance.jitter();
            }
        }
        return this._jitter;
    }

    @Override
    public ChronoUnit jitterDelayUnit() {
        if (this._jitterDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            this._jitterDelayUnit = this.onMethod ? (ChronoUnit)config.getOptionalValue(this.getConfigKeyForMethod("jitterDelayUnit"), ChronoUnit.class).orElse(null) : (ChronoUnit)config.getOptionalValue(this.getConfigKeyForClass("jitterDelayUnit"), ChronoUnit.class).orElse(null);
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = config.getOptionalValue("Retry/jitterDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (this._jitterDelayUnit == null) {
                this._jitterDelayUnit = this.instance.jitterDelayUnit();
            }
        }
        return this._jitterDelayUnit;
    }

    @Override
    public Class<? extends Throwable>[] retryOn() {
        if (this._retryOn == null) {
            Config config = ConfigProvider.getConfig();
            this._retryOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("retryOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("retryOn"), Class[].class).orElse(null);
            if (this._retryOn == null) {
                this._retryOn = config.getOptionalValue("Retry/retryOn", Class[].class).orElse(null);
            }
            if (this._retryOn == null) {
                this._retryOn = this.instance.retryOn();
            }
        }
        return this._retryOn;
    }

    @Override
    public Class<? extends Throwable>[] abortOn() {
        if (this._abortOn == null) {
            Config config = ConfigProvider.getConfig();
            this._abortOn = this.onMethod ? (Class[])config.getOptionalValue(this.getConfigKeyForMethod("abortOn"), Class[].class).orElse(null) : (Class[])config.getOptionalValue(this.getConfigKeyForClass("abortOn"), Class[].class).orElse(null);
            if (this._abortOn == null) {
                this._abortOn = config.getOptionalValue("Retry/abortOn", Class[].class).orElse(null);
            }
            if (this._abortOn == null) {
                this._abortOn = this.instance.abortOn();
            }
        }
        return this._abortOn;
    }

    private String getConfigKeyForMethod(String key) {
        return this.method.declaringClass.getName() + "/" + this.method.name + "/Retry/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return this.method.declaringClass.getName() + "/Retry/" + key;
    }
}

