/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.FaultTolerance;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class LazyFaultTolerance<T>
implements FaultTolerance<T> {
    private final Supplier<FaultTolerance<T>> builder;
    private final Class<?> asyncType;
    private volatile FaultTolerance<T> instance;

    LazyFaultTolerance(Supplier<FaultTolerance<T>> builder, Class<?> asyncType) {
        this.builder = builder;
        this.asyncType = asyncType;
    }

    public Class<?> internalGetAsyncType() {
        return this.asyncType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call(Callable<T> action) throws Exception {
        if (this.instance == null) {
            LazyFaultTolerance lazyFaultTolerance = this;
            synchronized (lazyFaultTolerance) {
                if (this.instance == null) {
                    this.instance = this.builder.get();
                }
            }
        }
        return this.instance.call(action);
    }
}

