/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timer;

import io.smallrye.faulttolerance.core.timer.TimerTask;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Transform;

@MessageLogger(projectCode="SRFTL", length=5)
interface TimerLogger
extends BasicLogger {
    public static final TimerLogger LOG = Logger.getMessageLogger(TimerLogger.class, TimerLogger.class.getPackage().getName());

    @Message(id=0, value="Timer %s created")
    @LogMessage(level=Logger.Level.TRACE)
    public void createdTimer(String var1);

    @Message(id=0, value="Timer %s shut down")
    @LogMessage(level=Logger.Level.TRACE)
    public void shutdownTimer(String var1);

    @Message(id=0, value="Scheduled timer task %s to run in %s millis")
    @LogMessage(level=Logger.Level.TRACE)
    public void scheduledTimerTask(@Transform(value={Transform.TransformType.IDENTITY_HASH_CODE}) TimerTask var1, long var2);

    @Message(id=0, value="Running timer task %s")
    @LogMessage(level=Logger.Level.TRACE)
    public void runningTimerTask(@Transform(value={Transform.TransformType.IDENTITY_HASH_CODE}) TimerTask var1);

    @Message(id=0, value="Cancelled timer task %s")
    @LogMessage(level=Logger.Level.TRACE)
    public void cancelledTimerTask(@Transform(value={Transform.TransformType.IDENTITY_HASH_CODE}) TimerTask var1);

    @Message(id=11000, value="Unexpected exception in timer loop, ignoring")
    @LogMessage(level=Logger.Level.WARN)
    public void unexpectedExceptionInTimerLoop(@Cause Exception var1);
}

