/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.invocation.Invoker;
import java.util.function.Function;
import javax.interceptor.InvocationContext;

public class InterceptionInvoker<V>
implements Invoker<V> {
    private final InvocationContext interceptionContext;

    public InterceptionInvoker(InvocationContext interceptionContext) {
        this.interceptionContext = interceptionContext;
    }

    @Override
    public int parametersCount() {
        return this.interceptionContext.getParameters().length;
    }

    @Override
    public <T> T getArgument(int index, Class<T> parameterType) {
        return parameterType.cast(this.interceptionContext.getParameters()[index]);
    }

    @Override
    public <T> T replaceArgument(int index, Class<T> parameterType, Function<T, T> transformation) {
        Object[] arguments = this.interceptionContext.getParameters();
        T oldArg = parameterType.cast(arguments[index]);
        T newArg = transformation.apply(oldArg);
        arguments[index] = newArg;
        this.interceptionContext.setParameters(arguments);
        return oldArg;
    }

    @Override
    public V proceed() throws Exception {
        return (V)this.interceptionContext.proceed();
    }
}

