/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.parameters;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ParameterImpl
extends ExtensibleImpl<Parameter>
implements Parameter,
ModelImpl {
    private String ref;
    private String name;
    private Parameter.In in;
    private String description;
    private Boolean required;
    private Schema schema;
    private Boolean allowEmptyValue;
    private Boolean deprecated;
    private Parameter.Style style;
    private Boolean explode;
    private Boolean allowReserved;
    private Object example;
    private Map<String, Example> examples;
    private Content content;
    private String paramRef;
    public static final String HIDDEN = "smallrye.internal.hidden";

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public void setRef(String ref) {
        if (ref != null && !ref.contains("/")) {
            ref = "#/components/parameters/" + ref;
        }
        this.ref = ref;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Override
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Override
    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
    }

    @Override
    public Parameter.Style getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Parameter.Style style) {
        this.style = style;
    }

    @Override
    public Boolean getExplode() {
        return this.explode;
    }

    @Override
    public void setExplode(Boolean explode) {
        this.explode = explode;
    }

    @Override
    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    @Override
    public void setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, Example> getExamples() {
        return ModelUtil.unmodifiableMap(this.examples);
    }

    @Override
    public void setExamples(Map<String, Example> examples) {
        this.examples = ModelUtil.replace(examples, LinkedHashMap::new);
    }

    @Override
    public Parameter addExample(String key, Example example) {
        this.examples = ModelUtil.add(key, example, this.examples, LinkedHashMap::new);
        return this;
    }

    @Override
    public void removeExample(String key) {
        ModelUtil.remove(this.examples, key);
    }

    @Override
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object example) {
        this.example = example;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public void setContent(Content content) {
        this.content = content;
    }

    @Override
    public Parameter.In getIn() {
        return this.in;
    }

    @Override
    public void setIn(Parameter.In in) {
        if (in == Parameter.In.PATH) {
            this.required = true;
        }
        this.in = in;
    }

    public String getParamRef() {
        return this.paramRef;
    }

    public void setParamRef(String paramRef) {
        this.paramRef = paramRef;
    }

    public static String getParamRef(Parameter parameter) {
        return parameter instanceof ParameterImpl ? ((ParameterImpl)parameter).getParamRef() : null;
    }

    public static boolean isHidden(Parameter parameter) {
        return parameter != null && parameter.getExtensions() != null && !parameter.getExtensions().isEmpty() && parameter.getExtensions().containsKey(HIDDEN) && parameter.getExtensions().get(HIDDEN) != null && parameter.getExtensions().get(HIDDEN).equals(true);
    }

    public static void setHidden(Parameter parameter, boolean hidden) {
        if (parameter != null) {
            parameter.addExtension(HIDDEN, hidden);
        }
    }
}

