/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnector;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaProducer;
import io.smallrye.reactive.messaging.kafka.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.Record;
import io.smallrye.reactive.messaging.kafka.SerializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.health.KafkaSinkHealth;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSenderProcessor;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaProducer;
import io.smallrye.reactive.messaging.kafka.impl.RuntimeKafkaSinkConfiguration;
import io.smallrye.reactive.messaging.kafka.impl.ce.KafkaCloudEventHelper;
import io.smallrye.reactive.messaging.kafka.tracing.HeaderInjectAdapter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.OffsetMetadataTooLarge;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;

public class KafkaSink {
    private final ReactiveKafkaProducer<?, ?> client;
    private final int partition;
    private final String topic;
    private final String key;
    private final SubscriberBuilder<? extends Message<?>, Void> subscriber;
    private final long retries;
    private final int deliveryTimeoutMs;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final KafkaSenderProcessor processor;
    private final boolean writeAsBinaryCloudEvent;
    private final boolean writeCloudEvents;
    private final boolean mandatoryCloudEventAttributeSet;
    private final boolean isTracingEnabled;
    private final KafkaSinkHealth health;
    private final boolean isHealthEnabled;
    private final boolean isHealthReadinessEnabled;
    private final String channel;
    private final RuntimeKafkaSinkConfiguration runtimeConfiguration;
    private static final Set<Class<? extends Throwable>> NOT_RECOVERABLE = new HashSet<Class>(Arrays.asList(InvalidTopicException.class, OffsetMetadataTooLarge.class, RecordBatchTooLargeException.class, RecordTooLargeException.class, UnknownServerException.class, SerializationException.class));

    public KafkaSink(KafkaConnectorOutgoingConfiguration config, KafkaCDIEvents kafkaCDIEvents, Instance<SerializationFailureHandler<?>> serializationFailureHandlers) {
        this.isTracingEnabled = config.getTracingEnabled();
        this.client = new ReactiveKafkaProducer(config, serializationFailureHandlers);
        kafkaCDIEvents.producer().fire(this.client.unwrap());
        this.partition = config.getPartition();
        this.retries = config.getRetries();
        int defaultDeliveryTimeoutMs = (Integer)ProducerConfig.configDef().defaultValues().get("delivery.timeout.ms");
        String deliveryTimeoutString = this.client.get("delivery.timeout.ms");
        this.deliveryTimeoutMs = deliveryTimeoutString != null ? Integer.parseInt(deliveryTimeoutString) : defaultDeliveryTimeoutMs;
        this.topic = config.getTopic().orElseGet(config::getChannel);
        this.key = config.getKey().orElse(null);
        this.writeCloudEvents = config.getCloudEvents();
        this.writeAsBinaryCloudEvent = config.getCloudEventsMode().equalsIgnoreCase("binary");
        boolean waitForWriteCompletion = config.getWaitForWriteCompletion();
        this.mandatoryCloudEventAttributeSet = config.getCloudEventsType().isPresent() && config.getCloudEventsSource().isPresent();
        this.channel = config.getChannel();
        this.runtimeConfiguration = RuntimeKafkaSinkConfiguration.buildFromConfiguration(config);
        if (config.getCloudEvents().booleanValue() && config.getCloudEventsMode().equalsIgnoreCase("structured") && !config.getValueSerializer().equalsIgnoreCase(StringSerializer.class.getName())) {
            KafkaLogging.log.invalidValueSerializerForStructuredCloudEvent(config.getValueSerializer());
            throw new IllegalStateException("Invalid value serializer to write a structured Cloud Event. " + StringSerializer.class.getName() + " must be used, found: " + config.getValueSerializer());
        }
        this.isHealthEnabled = config.getHealthEnabled();
        this.isHealthReadinessEnabled = config.getHealthReadinessEnabled();
        this.health = this.isHealthEnabled ? new KafkaSinkHealth(config, this.client.configuration(), this.client.unwrap()) : null;
        long requests = config.getMaxInflightMessages();
        if (requests <= 0L) {
            requests = Long.MAX_VALUE;
        }
        this.processor = new KafkaSenderProcessor(requests, waitForWriteCompletion, this.writeMessageToKafka());
        this.subscriber = ReactiveStreams.builder().via((Processor)this.processor).onError(f -> {
            KafkaLogging.log.unableToDispatch((Throwable)f);
            this.reportFailure((Throwable)f);
        }).ignore();
        KafkaLogging.log.connectedToKafka(this.client.getClientId(), config.getBootstrapServers(), this.topic);
    }

    private synchronized void reportFailure(Throwable failure) {
        if (this.failures.size() == 10) {
            this.failures.remove(0);
        }
        this.failures.add(failure);
    }

    private Function<Message<?>, Uni<Void>> writeMessageToKafka() {
        return message -> {
            try {
                Optional<io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata<?>> om = this.getOutgoingKafkaRecordMetadata((Message<?>)message);
                io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata outgoingMetadata = om.orElse(null);
                String actualTopic = outgoingMetadata == null || outgoingMetadata.getTopic() == null ? this.topic : outgoingMetadata.getTopic();
                OutgoingCloudEventMetadata ceMetadata = message.getMetadata(OutgoingCloudEventMetadata.class).orElse(null);
                io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata incomingMetadata = this.getIncomingKafkaRecordMetadata((Message<?>)message).orElse(null);
                ProducerRecord<?, ?> record = message.getPayload() instanceof ProducerRecord ? (ProducerRecord<?, ?>)message.getPayload() : (this.writeCloudEvents && (ceMetadata != null || this.mandatoryCloudEventAttributeSet) ? (this.writeAsBinaryCloudEvent ? KafkaCloudEventHelper.createBinaryRecord(message, actualTopic, outgoingMetadata, incomingMetadata, ceMetadata, this.runtimeConfiguration) : KafkaCloudEventHelper.createStructuredRecord(message, actualTopic, outgoingMetadata, incomingMetadata, ceMetadata, this.runtimeConfiguration)) : this.getProducerRecord((Message<?>)message, outgoingMetadata, incomingMetadata, actualTopic));
                KafkaLogging.log.sendingMessageToTopic((Message<?>)message, actualTopic);
                Uni<RecordMetadata> sendUni = this.client.send(record);
                Uni uni = sendUni.onItem().transformToUni(ignored -> {
                    KafkaLogging.log.successfullyToTopic((Message<?>)message, record.topic());
                    return Uni.createFrom().completionStage(message.ack());
                });
                if (this.retries == Integer.MAX_VALUE) {
                    uni = uni.onFailure(this::isRecoverable).retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(20L)).expireIn(this.deliveryTimeoutMs);
                } else if (this.retries > 0L) {
                    uni = uni.onFailure(this::isRecoverable).retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(20L)).atMost(this.retries);
                }
                return uni.onFailure().recoverWithUni(t -> {
                    KafkaLogging.log.nackingMessage((Message<?>)message, actualTopic, (Throwable)t);
                    return Uni.createFrom().completionStage(message.nack((Throwable)t));
                });
            }
            catch (RuntimeException e) {
                KafkaLogging.log.unableToSendRecord(e);
                return Uni.createFrom().failure(e);
            }
        };
    }

    private boolean isRecoverable(Throwable f) {
        return !NOT_RECOVERABLE.contains(f.getClass());
    }

    private Optional<io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata<?>> getOutgoingKafkaRecordMetadata(Message<?> message) {
        Optional<io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata<?>> metadata = message.getMetadata(io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata.class).map(x -> x);
        if (metadata.isPresent()) {
            return metadata;
        }
        metadata = message.getMetadata(OutgoingKafkaRecordMetadata.class).map(x -> x);
        return metadata;
    }

    private Optional<io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata<?, ?>> getIncomingKafkaRecordMetadata(Message<?> message) {
        Optional<io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata<?, ?>> metadata = message.getMetadata(io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata.class).map(x -> x);
        if (metadata.isPresent()) {
            return metadata;
        }
        metadata = message.getMetadata(IncomingKafkaRecordMetadata.class).map(x -> x);
        return metadata;
    }

    private ProducerRecord<?, ?> getProducerRecord(Message<?> message, io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata<?> om, io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata<?, ?> im, String actualTopic) {
        int actualPartition = om == null || om.getPartition() <= -1 ? this.partition : om.getPartition();
        Object actualKey = this.getKey(message, om);
        long actualTimestamp = om == null || om.getTimestamp() == null ? -1L : (om.getTimestamp() != null ? om.getTimestamp().toEpochMilli() : -1L);
        RecordHeaders kafkaHeaders = new RecordHeaders();
        if (!StringUtils.isNullOrEmpty(this.runtimeConfiguration.getPropagateHeaders()) && im != null && im.getHeaders() != null) {
            Set configuredHeaders = Arrays.stream(this.runtimeConfiguration.getPropagateHeaders().split(",")).map(String::trim).collect(Collectors.toSet());
            for (Header header : im.getHeaders()) {
                if (!configuredHeaders.contains(header.key())) continue;
                kafkaHeaders.add(header);
            }
        }
        if (om != null && om.getHeaders() != null) {
            om.getHeaders().forEach(kafkaHeaders::add);
        }
        this.createOutgoingTrace(message, actualTopic, actualPartition, kafkaHeaders);
        Object payload = message.getPayload();
        if (payload instanceof Record) {
            payload = ((Record)payload).value();
        }
        return new ProducerRecord(actualTopic, actualPartition == -1 ? null : Integer.valueOf(actualPartition), actualTimestamp == -1L ? null : Long.valueOf(actualTimestamp), actualKey, payload, kafkaHeaders);
    }

    private Object getKey(Message<?> message, io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata<?> metadata) {
        if (metadata != null && metadata.getKey() != null) {
            return metadata.getKey();
        }
        if (message.getPayload() instanceof Record) {
            return ((Record)message.getPayload()).key();
        }
        if (this.runtimeConfiguration.getPropagateRecordKey().booleanValue()) {
            return message.getMetadata(io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata.class).map(io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata::getKey).orElse(this.key);
        }
        return this.key;
    }

    private void createOutgoingTrace(Message<?> message, String topic, int partition, Headers headers) {
        if (this.isTracingEnabled) {
            Optional<TracingMetadata> tracingMetadata = TracingMetadata.fromMessage(message);
            SpanBuilder spanBuilder = KafkaConnector.TRACER.spanBuilder(topic + " send").setSpanKind(SpanKind.PRODUCER);
            if (tracingMetadata.isPresent()) {
                Context parentSpanContext = tracingMetadata.get().getCurrentContext();
                if (parentSpanContext != null) {
                    spanBuilder.setParent(parentSpanContext);
                } else {
                    spanBuilder.setNoParent();
                }
            } else {
                spanBuilder.setNoParent();
            }
            Span span = spanBuilder.startSpan();
            Scope scope = span.makeCurrent();
            if (partition != -1) {
                span.setAttribute(SemanticAttributes.MESSAGING_KAFKA_PARTITION, partition);
            }
            span.setAttribute(SemanticAttributes.MESSAGING_SYSTEM, "kafka");
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION, topic);
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, "topic");
            GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), headers, HeaderInjectAdapter.SETTER);
            span.end();
            scope.close();
        }
    }

    public SubscriberBuilder<? extends Message<?>, Void> getSink() {
        return this.subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isAlive(HealthReport.HealthReportBuilder builder) {
        if (this.isHealthEnabled) {
            ArrayList<Throwable> actualFailures;
            KafkaSink kafkaSink = this;
            synchronized (kafkaSink) {
                actualFailures = new ArrayList<Throwable>(this.failures);
            }
            if (!actualFailures.isEmpty()) {
                builder.add(this.channel, false, actualFailures.stream().map(Throwable::getMessage).collect(Collectors.joining()));
            } else {
                builder.add(this.channel, true);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.health != null && this.isHealthReadinessEnabled) {
            this.health.isReady(builder);
        }
    }

    public void isStarted(HealthReport.HealthReportBuilder builder) {
        if (this.health != null) {
            this.health.isStarted(builder);
        }
    }

    public void closeQuietly() {
        if (this.processor != null) {
            this.processor.cancel();
        }
        try {
            this.client.close();
        }
        catch (Throwable e) {
            KafkaLogging.log.errorWhileClosingWriteStream(e);
        }
        if (this.health != null) {
            this.health.close();
        }
    }

    public String getChannel() {
        return this.channel;
    }

    public KafkaProducer<?, ?> getProducer() {
        return this.client;
    }
}

