/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.locals;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.constraint.Nullable;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public interface ContextAwareMessage<T>
extends Message<T> {
    @Nullable
    public static LocalContextMetadata captureLocalContextMetadata() {
        Context duplicatedContext = VertxContext.createNewDuplicatedContext();
        if (duplicatedContext == null) {
            return null;
        }
        return new LocalContextMetadata(duplicatedContext);
    }

    public static <T> ContextAwareMessage<T> of(final T payload) {
        LocalContextMetadata contextMetadata = ContextAwareMessage.captureLocalContextMetadata();
        final Metadata metadata = contextMetadata == null ? Metadata.empty() : Metadata.of(new Object[]{contextMetadata});
        return new ContextAwareMessage<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return metadata;
            }
        };
    }

    public static <T> Message<T> withContextMetadata(Message<T> message) {
        LocalContextMetadata contextMetadata = ContextAwareMessage.captureLocalContextMetadata();
        return contextMetadata == null ? message : message.addMetadata(contextMetadata);
    }

    @CheckReturnValue
    public static Metadata captureContextMetadata(Metadata metadata) {
        LocalContextMetadata localContextMetadata = ContextAwareMessage.captureLocalContextMetadata();
        if (localContextMetadata == null) {
            return metadata;
        }
        return metadata.with(localContextMetadata);
    }

    @CheckReturnValue
    public static Metadata captureContextMetadata(Object ... metadata) {
        return ContextAwareMessage.captureContextMetadata(Metadata.of(metadata));
    }

    @CheckReturnValue
    public static Metadata captureContextMetadata(Iterable<Object> metadata) {
        return ContextAwareMessage.captureContextMetadata(Metadata.from(metadata));
    }

    default public Optional<LocalContextMetadata> getContextMetadata() {
        return this.getMetadata().get(LocalContextMetadata.class);
    }
}

