/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientInternal;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.multipart.MultipartForm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpRequestImpl<T>
implements HttpRequest<T> {
    final WebClientInternal client;
    final WebClientOptions options;
    ProxyOptions proxyOptions;
    SocketAddress serverAddress;
    MultiMap params;
    HttpMethod method;
    String protocol;
    private Integer port;
    private String host;
    String virtualHost;
    String uri;
    MultiMap headers;
    long timeout = -1L;
    BodyCodec<T> codec;
    boolean followRedirects;
    Boolean ssl;
    boolean multipartMixed = true;
    public List<ResponsePredicate> expectations;

    HttpRequestImpl(WebClientInternal client, HttpMethod method, SocketAddress serverAddress, Boolean ssl, Integer port, String host, String uri, BodyCodec<T> codec, WebClientOptions options, ProxyOptions proxyOptions) {
        this(client, method, serverAddress, null, ssl, port, host, uri, codec, options, proxyOptions);
    }

    HttpRequestImpl(WebClientInternal client, HttpMethod method, SocketAddress serverAddress, Boolean ssl, Integer port, String host, String uri, BodyCodec<T> codec, WebClientOptions options) {
        this(client, method, serverAddress, null, ssl, port, host, uri, codec, options, null);
    }

    HttpRequestImpl(WebClientInternal client, HttpMethod method, SocketAddress serverAddress, String protocol, Boolean ssl, Integer port, String host, String uri, BodyCodec<T> codec, WebClientOptions options, ProxyOptions proxyOptions) {
        this.client = client;
        this.method = method;
        this.protocol = protocol;
        this.codec = codec;
        this.port = port;
        this.host = host;
        this.uri = uri;
        this.ssl = ssl;
        this.serverAddress = serverAddress;
        this.followRedirects = options.isFollowRedirects();
        this.options = options;
        this.proxyOptions = proxyOptions != null ? new ProxyOptions(proxyOptions) : null;
        this.headers = options.isUserAgentEnabled() ? HttpHeaders.set(HttpHeaders.USER_AGENT, (CharSequence)options.getUserAgent()) : HttpHeaders.headers();
    }

    private HttpRequestImpl(HttpRequestImpl<T> other) {
        this.client = other.client;
        this.serverAddress = other.serverAddress;
        this.options = other.options;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.method = other.method;
        this.protocol = other.protocol;
        this.port = other.port;
        this.host = other.host;
        this.timeout = other.timeout;
        this.uri = other.uri;
        this.headers = other.headers != null ? HttpHeaders.headers().addAll(other.headers) : HttpHeaders.headers();
        this.params = other.params != null ? MultiMap.caseInsensitiveMultiMap().addAll(other.params) : null;
        this.codec = other.codec;
        this.followRedirects = other.followRedirects;
        this.ssl = other.ssl;
        this.multipartMixed = other.multipartMixed;
        this.virtualHost = other.virtualHost;
        this.expectations = other.expectations != null ? new ArrayList<ResponsePredicate>(other.expectations) : null;
    }

    @Override
    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        this.codec = responseCodec;
        return this;
    }

    @Override
    public HttpRequest<T> method(HttpMethod value) {
        this.method = value;
        return this;
    }

    public HttpMethod method() {
        return this.method;
    }

    @Override
    public HttpRequest<T> port(int value) {
        this.port = value;
        return this;
    }

    public int port() {
        return this.port != null ? this.port.intValue() : this.options.getDefaultPort();
    }

    @Override
    public HttpRequest<T> host(String value) {
        this.host = value;
        return this;
    }

    public String host() {
        return this.host != null ? this.host : this.options.getDefaultHost();
    }

    @Override
    public HttpRequest<T> virtualHost(String value) {
        this.virtualHost = value;
        return this;
    }

    public String virtualHost() {
        return this.virtualHost;
    }

    @Override
    public HttpRequest<T> uri(String value) {
        this.params = null;
        this.uri = value;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    @Override
    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.headers().addAll(headers);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.headers();
        }
        return this.headers;
    }

    @Override
    public HttpRequest<T> authentication(Credentials credentials) {
        this.putHeader(HttpHeaders.AUTHORIZATION.toString(), credentials.toHttpAuthorization());
        return this;
    }

    @Override
    public HttpRequest<T> ssl(Boolean value) {
        this.ssl = value;
        return this;
    }

    public Boolean ssl() {
        return this.ssl;
    }

    @Override
    public HttpRequest<T> timeout(long value) {
        this.timeout = value;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.queryParams().add(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.queryParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> followRedirects(boolean value) {
        this.followRedirects = value;
        return this;
    }

    @Override
    public HttpRequest<T> proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public HttpRequest<T> expect(ResponsePredicate expectation) {
        if (this.expectations == null) {
            this.expectations = new ArrayList<ResponsePredicate>();
        }
        this.expectations.add(expectation);
        return this;
    }

    @Override
    public MultiMap queryParams() {
        int idx;
        if (this.params == null) {
            this.params = MultiMap.caseInsensitiveMultiMap();
        }
        if (this.params.isEmpty() && (idx = this.uri.indexOf(63)) >= 0) {
            QueryStringDecoder dec = new QueryStringDecoder(this.uri);
            dec.parameters().forEach((name, value) -> this.params.add((String)name, (Iterable<String>)value));
            this.uri = this.uri.substring(0, idx);
        }
        return this.params;
    }

    @Override
    public HttpRequest<T> copy() {
        return new HttpRequestImpl<T>(this);
    }

    @Override
    public HttpRequest<T> multipartMixed(boolean allow) {
        this.multipartMixed = allow;
        return this;
    }

    @Override
    public void sendStream(ReadStream<Buffer> body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void send(Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, null, handler);
    }

    @Override
    public void sendBuffer(Buffer body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void sendJsonObject(JsonObject body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendJson(Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendForm(MultiMap body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.sendForm(body, "UTF-8", handler);
    }

    @Override
    public void sendForm(MultiMap body, String charset, Handler<AsyncResult<HttpResponse<T>>> handler) {
        MultipartForm parts = MultipartForm.create();
        for (Map.Entry attribute : body) {
            parts.attribute((String)attribute.getKey(), (String)attribute.getValue());
        }
        parts.setCharset(charset);
        this.send("application/x-www-form-urlencoded", parts, handler);
    }

    @Override
    public void sendMultipartForm(MultipartForm body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("multipart/form-data", body, handler);
    }

    void send(String contentType, Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        HttpContext<T> ctx = this.client.createContext(handler);
        ctx.prepareRequest(this, contentType, body);
    }

    void mergeHeaders(RequestOptions options) {
        if (this.headers != null) {
            MultiMap tmp = options.getHeaders();
            if (tmp == null) {
                tmp = MultiMap.caseInsensitiveMultiMap();
                options.setHeaders(tmp);
            }
            tmp.addAll(this.headers);
        }
    }
}

