/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.api;

import java.util.Iterator;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataStore;
import org.drools.ruleunits.api.DataStream;
import org.drools.ruleunits.api.SingletonStore;
import org.kie.api.internal.utils.KieService;

public interface DataSource<T>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    public void subscribe(DataProcessor<T> var1);

    public static <T> DataStream<T> createStream() {
        return FactoryHolder.get().createStream();
    }

    public static <T> DataStore<T> createStore() {
        return FactoryHolder.get().createStore();
    }

    public static <T> SingletonStore<T> createSingleton() {
        return FactoryHolder.get().createSingleton();
    }

    public static class FactoryHolder {
        public static Factory get() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static Factory INSTANCE = KieService.load(Factory.class);

            private LazyHolder() {
            }
        }
    }

    public static interface Factory
    extends KieService {
        public <T> DataStream<T> createStream();

        public <T> DataStore<T> createStore();

        public <T> SingletonStore<T> createSingleton();
    }
}

