/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.ResolutionContext;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.ProtobufTagMarshallerDelegate;
import org.infinispan.protostream.impl.parser.SquareProtoParser;

public final class SerializationContextImpl
implements SerializationContext {
    private static final Log log = Log.LogFactory.getLog(SerializationContextImpl.class);
    private final StampedLock descriptorLock = new StampedLock();
    private final Configuration configuration;
    private final SquareProtoParser parser;
    private final Map<String, FileDescriptor> fileDescriptors = new LinkedHashMap<String, FileDescriptor>();
    private final Map<Integer, GenericDescriptor> typeIds = new HashMap<Integer, GenericDescriptor>();
    private final Map<String, GenericDescriptor> genericDescriptors = new HashMap<String, GenericDescriptor>();
    private final Map<String, EnumValueDescriptor> enumValueDescriptors = new HashMap<String, EnumValueDescriptor>();
    private final StampedLock manifestLock = new StampedLock();
    private final Map<String, Registration> marshallersByName = new HashMap<String, Registration>();
    private final Map<Class<?>, Registration> marshallersByClass = new HashMap();
    private final List<SerializationContext.MarshallerProvider> legacyMarshallerProviders = new ArrayList<SerializationContext.MarshallerProvider>();

    public SerializationContextImpl(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration argument cannot be null");
        }
        this.configuration = configuration;
        this.parser = new SquareProtoParser(configuration);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FileDescriptor> getFileDescriptors() {
        long stamp = this.descriptorLock.readLock();
        try {
            Map<String, FileDescriptor> map = Collections.unmodifiableMap(new HashMap<String, FileDescriptor>(this.fileDescriptors));
            return map;
        }
        finally {
            this.descriptorLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, GenericDescriptor> getGenericDescriptors() {
        long stamp = this.descriptorLock.readLock();
        try {
            Map<String, GenericDescriptor> map = Collections.unmodifiableMap(new HashMap<String, GenericDescriptor>(this.genericDescriptors));
            return map;
        }
        finally {
            this.descriptorLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProtoFiles(FileDescriptorSource source) throws DescriptorParserException {
        if (log.isDebugEnabled()) {
            log.debugf("Registering proto files : %s", (Object)source.getFiles().keySet());
        }
        Map<String, FileDescriptor> fileDescriptorMap = this.parser.parse(source);
        long stamp = this.descriptorLock.writeLock();
        try {
            for (String fileName : fileDescriptorMap.keySet()) {
                FileDescriptor oldFileDescriptor = this.fileDescriptors.get(fileName);
                if (oldFileDescriptor == null) continue;
                this.unregisterFileDescriptorTypes(oldFileDescriptor);
            }
            this.fileDescriptors.putAll(fileDescriptorMap);
            ResolutionContext resolutionContext = new ResolutionContext(source.getProgressCallback(), this.fileDescriptors, this.genericDescriptors, this.typeIds, this.enumValueDescriptors);
            resolutionContext.resolve();
        }
        finally {
            this.descriptorLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProtoFile(String fileName) {
        block4: {
            log.debugf("Unregistering proto file : %s", (Object)fileName);
            long stamp = this.descriptorLock.writeLock();
            try {
                FileDescriptor fileDescriptor = this.fileDescriptors.remove(fileName);
                if (fileDescriptor != null) {
                    this.unregisterFileDescriptorTypes(fileDescriptor);
                    break block4;
                }
                throw new IllegalArgumentException("File " + fileName + " does not exist");
            }
            finally {
                this.descriptorLock.unlockWrite(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProtoFiles(Set<String> fileNames) {
        log.debugf("Unregistering proto files : %s", (Object)fileNames);
        long stamp = this.descriptorLock.writeLock();
        try {
            for (String fileName : fileNames) {
                FileDescriptor fileDescriptor = this.fileDescriptors.remove(fileName);
                if (fileDescriptor != null) {
                    this.unregisterFileDescriptorTypes(fileDescriptor);
                    continue;
                }
                throw new IllegalArgumentException("File " + fileName + " does not exist");
            }
        }
        finally {
            this.descriptorLock.unlockWrite(stamp);
        }
    }

    @GuardedBy(value="descriptorLock")
    private void unregisterFileDescriptorTypes(FileDescriptor fileDescriptor) {
        if (fileDescriptor.isResolved()) {
            for (GenericDescriptor d : fileDescriptor.getTypes().values()) {
                Integer typeId = d.getTypeId();
                if (typeId != null) {
                    this.typeIds.remove(typeId);
                }
                if (!(d instanceof EnumDescriptor)) continue;
                for (EnumValueDescriptor ev : ((EnumDescriptor)d).getValues()) {
                    this.enumValueDescriptors.remove(ev.getScopedName());
                }
            }
            this.genericDescriptors.keySet().removeAll(fileDescriptor.getTypes().keySet());
            fileDescriptor.markUnresolved();
        }
        for (FileDescriptor fd : fileDescriptor.getDependants().values()) {
            this.unregisterFileDescriptorTypes(fd);
        }
    }

    @Override
    public Descriptor getMessageDescriptor(String fullTypeName) {
        GenericDescriptor descriptor = this.getDescriptorByName(fullTypeName);
        if (!(descriptor instanceof Descriptor)) {
            throw new IllegalArgumentException(fullTypeName + " is not a message type");
        }
        return (Descriptor)descriptor;
    }

    @Override
    public EnumDescriptor getEnumDescriptor(String fullTypeName) {
        GenericDescriptor descriptor = this.getDescriptorByName(fullTypeName);
        if (!(descriptor instanceof EnumDescriptor)) {
            throw new IllegalArgumentException(fullTypeName + " is not an enum type");
        }
        return (EnumDescriptor)descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            Registration existingByName = this.marshallersByName.get(marshaller.getTypeName());
            Registration existingByClass = this.marshallersByClass.get(marshaller.getJavaClass());
            if (existingByName != null && existingByName.marshallerProvider != null || existingByClass != null && existingByClass.marshallerProvider != null) {
                throw new IllegalArgumentException("The given marshaller attempts to override an existing marshaller registered indirectly via an InstanceMarshallerProvider. Please unregister it first.");
            }
            if (existingByName != null) {
                Registration anotherByClass = this.marshallersByClass.get(existingByName.marshallerDelegate.getMarshaller().getJavaClass());
                if (anotherByClass == null) {
                    throw new IllegalStateException("Inconsistent marshaller definitions!");
                }
                if (anotherByClass.marshallerProvider != null) {
                    throw new IllegalArgumentException("The given marshaller attempts to override an existing marshaller registered indirectly via an InstanceMarshallerProvider. Please unregister that first.");
                }
                if (!anotherByClass.marshallerDelegate.getMarshaller().getTypeName().equals(marshaller.getTypeName())) {
                    throw new IllegalStateException("Inconsistent marshaller definitions!");
                }
                this.marshallersByClass.remove(existingByName.marshallerDelegate.getMarshaller().getJavaClass());
            }
            if (existingByClass != null) {
                this.marshallersByName.remove(existingByClass.marshallerDelegate.getMarshaller().getTypeName());
            }
            Registration registration = new Registration(this.makeMarshallerDelegate(marshaller));
            this.marshallersByClass.put(marshaller.getJavaClass(), registration);
            this.marshallersByName.put(marshaller.getTypeName(), registration);
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    private <T> BaseMarshallerDelegate<T> makeMarshallerDelegate(BaseMarshaller<T> marshaller) {
        if (marshaller.getJavaClass().isEnum() && !(marshaller instanceof EnumMarshaller)) {
            throw new IllegalArgumentException("Invalid marshaller (the produced class is a Java Enum, but the marshaller is not an EnumMarshaller) : " + marshaller.getClass().getName());
        }
        if (marshaller instanceof EnumMarshaller) {
            if (!marshaller.getJavaClass().isEnum()) {
                throw new IllegalArgumentException("Invalid enum marshaller (the produced class is not a Java Enum) : " + marshaller.getClass().getName());
            }
            EnumDescriptor enumDescriptor = this.getEnumDescriptor(marshaller.getTypeName());
            return new EnumMarshallerDelegate((EnumMarshaller)marshaller, enumDescriptor);
        }
        if (marshaller instanceof ProtobufTagMarshaller) {
            return new ProtobufTagMarshallerDelegate((ProtobufTagMarshaller)marshaller);
        }
        Descriptor messageDescriptor = this.getMessageDescriptor(marshaller.getTypeName());
        return new MessageMarshallerDelegate((MessageMarshaller)marshaller, messageDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMarshaller(BaseMarshaller<?> marshaller) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            Registration existingByName = this.marshallersByName.get(marshaller.getTypeName());
            if (existingByName == null || existingByName.marshallerDelegate.getMarshaller() != marshaller) {
                throw new IllegalArgumentException("The given marshaller was not previously registered with this SerializationContext");
            }
            if (existingByName.marshallerProvider != null) {
                throw new IllegalArgumentException("Attempting to unregister a marshaller that was registered indirectly via an InstanceMarshallerProvider. Please use the same mechanism to unregister it.");
            }
            this.marshallersByName.remove(marshaller.getTypeName());
            this.marshallersByClass.remove(marshaller.getJavaClass());
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void registerMarshallerProvider(SerializationContext.MarshallerProvider marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            this.legacyMarshallerProviders.add(marshallerProvider);
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void unregisterMarshallerProvider(SerializationContext.MarshallerProvider marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            this.legacyMarshallerProviders.remove(marshallerProvider);
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            Registration byClass = this.marshallersByClass.get(marshallerProvider.getJavaClass());
            if (byClass != null) {
                if (byClass.marshallerProvider == null) {
                    throw new IllegalArgumentException("A marshaller was already registered for the same class. Please unregister it first.");
                }
                if (!byClass.marshallerProvider.getTypeNames().equals(marshallerProvider.getTypeNames())) {
                    throw new IllegalArgumentException("An InstanceMarshallerProvider was already registered for the same class but maps to a different set of protobuf types. Please unregister it first.");
                }
            }
            this.marshallersByClass.put(marshallerProvider.getJavaClass(), new Registration(marshallerProvider));
            for (String typeName : marshallerProvider.getTypeNames()) {
                BaseMarshaller<?> marshaller = marshallerProvider.getMarshaller(typeName);
                this.marshallersByName.put(typeName, new Registration(this.makeMarshallerDelegate(marshaller), marshallerProvider));
            }
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMarshallerProvider(SerializationContext.InstanceMarshallerProvider<?> marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        long stamp = this.manifestLock.writeLock();
        try {
            Registration byClass = this.marshallersByClass.get(marshallerProvider.getJavaClass());
            if (byClass == null || byClass.marshallerProvider != marshallerProvider) {
                throw new IllegalArgumentException("The given InstanceMarshallerProvider was not previously registered with this SerializationContext");
            }
            this.marshallersByClass.remove(marshallerProvider.getJavaClass());
            this.marshallersByName.keySet().removeAll(marshallerProvider.getTypeNames());
        }
        finally {
            this.manifestLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canMarshall(Class<?> javaClass) {
        long stamp = this.manifestLock.readLock();
        try {
            boolean bl = this.marshallersByClass.containsKey(javaClass) || this.getMarshallerFromLegacyProvider(javaClass) != null;
            return bl;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canMarshall(String fullTypeName) {
        long stamp = this.manifestLock.readLock();
        try {
            boolean bl = this.marshallersByName.containsKey(fullTypeName) || this.getMarshallerFromLegacyProvider(fullTypeName) != null;
            return bl;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canMarshall(Object object) {
        Class<?> javaClass = object.getClass();
        long stamp = this.manifestLock.readLock();
        try {
            BaseMarshaller<?> marshaller;
            Registration registration = this.marshallersByClass.get(javaClass);
            if (registration != null) {
                if (registration.marshallerProvider != null) {
                    String typeName = registration.marshallerProvider.getTypeName(object);
                    if (typeName == null) {
                        throw new IllegalArgumentException("No marshaller registered for object of Java type " + javaClass.getName() + " : " + object);
                    }
                    registration = this.marshallersByName.get(typeName);
                }
                if (registration != null) {
                    boolean typeName = true;
                    return typeName;
                }
            }
            boolean bl = (marshaller = this.getMarshallerFromLegacyProvider(javaClass)) != null;
            return bl;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(T object) {
        return this.getMarshallerDelegate(object).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String fullTypeName) {
        return this.getMarshallerDelegate((T)fullTypeName).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.getMarshallerDelegate((T)clazz).getMarshaller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BaseMarshallerDelegate<T> getMarshallerDelegate(String typeName) {
        long stamp = this.manifestLock.readLock();
        try {
            Registration registration = this.marshallersByName.get(typeName);
            if (registration != null) {
                BaseMarshallerDelegate<?> baseMarshallerDelegate = registration.marshallerDelegate;
                return baseMarshallerDelegate;
            }
            BaseMarshaller<T> marshaller = this.getMarshallerFromLegacyProvider(typeName);
            if (marshaller == null) {
                throw new IllegalArgumentException("No marshaller registered for Protobuf type " + typeName);
            }
            BaseMarshallerDelegate<T> baseMarshallerDelegate = this.makeMarshallerDelegate(marshaller);
            return baseMarshallerDelegate;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BaseMarshallerDelegate<T> getMarshallerDelegate(Class<T> javaClass) {
        long stamp = this.manifestLock.readLock();
        try {
            Registration registration = this.marshallersByClass.get(javaClass);
            if (registration != null) {
                if (registration.marshallerProvider != null) {
                    throw new IllegalArgumentException("Java type " + javaClass.getName() + " is mapped to multiple protobuf types : " + registration.marshallerProvider.getTypeNames() + ". Object instance needed for disambiguation.");
                }
                BaseMarshallerDelegate<?> baseMarshallerDelegate = registration.marshallerDelegate;
                return baseMarshallerDelegate;
            }
            BaseMarshaller<T> marshaller = this.getMarshallerFromLegacyProvider(javaClass);
            if (marshaller == null) {
                throw new IllegalArgumentException("No marshaller registered for Java type " + javaClass.getName());
            }
            BaseMarshallerDelegate<T> baseMarshallerDelegate = this.makeMarshallerDelegate(marshaller);
            return baseMarshallerDelegate;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> BaseMarshallerDelegate<T> getMarshallerDelegate(T object) {
        Class<?> javaClass = object.getClass();
        long stamp = this.manifestLock.readLock();
        try {
            BaseMarshaller<?> marshaller;
            Registration registration = this.marshallersByClass.get(javaClass);
            if (registration != null) {
                Object typeName;
                if (registration.marshallerProvider != null) {
                    typeName = registration.marshallerProvider.getTypeName(object);
                    if (typeName == null) {
                        throw new IllegalArgumentException("No marshaller registered for object of Java type " + javaClass.getName() + " : " + object);
                    }
                    registration = this.marshallersByName.get(typeName);
                }
                if (registration != null) {
                    typeName = registration.marshallerDelegate;
                    return typeName;
                }
            }
            if ((marshaller = this.getMarshallerFromLegacyProvider(javaClass)) == null) {
                throw new IllegalArgumentException("No marshaller registered for object of Java type " + javaClass.getName() + " : " + object);
            }
            BaseMarshallerDelegate<?> baseMarshallerDelegate = this.makeMarshallerDelegate(marshaller);
            return baseMarshallerDelegate;
        }
        finally {
            this.manifestLock.unlockRead(stamp);
        }
    }

    @GuardedBy(value="manifestLock")
    private <T> BaseMarshaller<T> getMarshallerFromLegacyProvider(Class<T> javaClass) {
        if (!this.legacyMarshallerProviders.isEmpty()) {
            for (SerializationContext.MarshallerProvider mp : this.legacyMarshallerProviders) {
                BaseMarshaller<?> marshaller = mp.getMarshaller(javaClass);
                if (marshaller == null) continue;
                return marshaller;
            }
        }
        return null;
    }

    @GuardedBy(value="manifestLock")
    private <T> BaseMarshaller<T> getMarshallerFromLegacyProvider(String fullTypeName) {
        if (!this.legacyMarshallerProviders.isEmpty()) {
            for (SerializationContext.MarshallerProvider mp : this.legacyMarshallerProviders) {
                BaseMarshaller<?> marshaller = mp.getMarshaller(fullTypeName);
                if (marshaller == null) continue;
                return marshaller;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String getTypeNameById(Integer typeId) {
        return this.getDescriptorByTypeId(typeId).getFullName();
    }

    @Override
    @Deprecated
    public Integer getTypeIdByName(String fullTypeName) {
        return this.getDescriptorByName(fullTypeName).getTypeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescriptor getDescriptorByName(String fullTypeName) {
        if (fullTypeName == null) {
            throw new IllegalArgumentException("Type name argument cannot be null");
        }
        long stamp = this.descriptorLock.readLock();
        try {
            GenericDescriptor descriptor = this.genericDescriptors.get(fullTypeName);
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown type name : " + fullTypeName);
            }
            GenericDescriptor genericDescriptor = descriptor;
            return genericDescriptor;
        }
        finally {
            this.descriptorLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescriptor getDescriptorByTypeId(Integer typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException("Type id argument cannot be null");
        }
        long stamp = this.descriptorLock.readLock();
        try {
            GenericDescriptor descriptor = this.typeIds.get(typeId);
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown type id : " + typeId);
            }
            GenericDescriptor genericDescriptor = descriptor;
            return genericDescriptor;
        }
        finally {
            this.descriptorLock.unlockRead(stamp);
        }
    }

    private static final class Registration {
        final BaseMarshallerDelegate<?> marshallerDelegate;
        final SerializationContext.InstanceMarshallerProvider<?> marshallerProvider;

        Registration(BaseMarshallerDelegate<?> marshallerDelegate) {
            this.marshallerDelegate = marshallerDelegate;
            this.marshallerProvider = null;
        }

        Registration(BaseMarshallerDelegate<?> marshallerDelegate, SerializationContext.InstanceMarshallerProvider<?> marshallerProvider) {
            this.marshallerDelegate = marshallerDelegate;
            this.marshallerProvider = marshallerProvider;
        }

        Registration(SerializationContext.InstanceMarshallerProvider<?> marshallerProvider) {
            this.marshallerDelegate = null;
            this.marshallerProvider = marshallerProvider;
        }
    }
}

