/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.jboss.resteasy.annotations.ContentEncoding;
import org.jboss.resteasy.plugins.interceptors.ClientContentEncodingAnnotationFilter;

@ConstrainedTo(value=RuntimeType.CLIENT)
public class ClientContentEncodingAnnotationFeature
implements DynamicFeature {
    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Class<?> declaring = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (declaring == null || method == null) {
            return;
        }
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            String encoding = this.getEncoding(annotations);
            if (encoding == null) continue;
            configurable.register(new ClientContentEncodingAnnotationFilter(encoding));
            return;
        }
    }

    protected String getEncoding(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ContentEncoding.class)) continue;
            return annotation.annotationType().getAnnotation(ContentEncoding.class).value();
        }
        return null;
    }
}

