/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.AbstractPatchMethodFilter;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;

@Provider
@Priority(value=0x7FFFFFFF)
public class PatchMethodFilter
extends AbstractPatchMethodFilter {
    private volatile ObjectMapper objectMapper;

    @Override
    protected boolean isDisabled(ContainerRequestContext requestContext) {
        return this.readFilterDisabledFlag(requestContext) != AbstractPatchMethodFilter.FilterFlag.JACKSON;
    }

    @Override
    protected byte[] applyPatch(ContainerRequestContext requestContext, byte[] targetJsonBytes) throws IOException, Failure {
        HttpRequest request = ResteasyContext.getContextData(HttpRequest.class);
        ObjectMapper mapper = this.getObjectMapper();
        PolymorphicTypeValidator ptv = mapper.getPolymorphicTypeValidator();
        if (ptv == null || ptv instanceof LaissezFaireSubTypeValidator) {
            mapper.setPolymorphicTypeValidator(new WhiteListPolymorphicTypeValidatorBuilder().build());
        }
        JsonNode targetJson = mapper.readValue(targetJsonBytes, JsonNode.class);
        JsonNode result = null;
        ByteArrayOutputStream targetOutputStream = new ByteArrayOutputStream();
        try {
            if (MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType())) {
                JsonPatch patch = JsonPatch.fromJson(mapper.readValue(request.getInputStream(), JsonNode.class));
                result = patch.apply(targetJson);
            } else {
                JsonMergePatch mergePatch = JsonMergePatch.fromJson(mapper.readValue(request.getInputStream(), JsonNode.class));
                result = mergePatch.apply(targetJson);
            }
            mapper.writeValue(targetOutputStream, (Object)result);
        }
        catch (JsonPatchException e) {
            throw new Failure((Throwable)e, 409);
        }
        return targetOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper getObjectMapper() {
        ObjectMapper currentObjectMapper = this.objectMapper;
        if (currentObjectMapper == null) {
            PatchMethodFilter patchMethodFilter = this;
            synchronized (patchMethodFilter) {
                currentObjectMapper = this.objectMapper;
                if (currentObjectMapper == null) {
                    ObjectMapper contextMapper = this.getContextObjectMapper();
                    this.objectMapper = currentObjectMapper = contextMapper == null ? new ObjectMapper() : contextMapper;
                }
            }
        }
        return currentObjectMapper;
    }

    private ObjectMapper getContextObjectMapper() {
        ContextResolver<ObjectMapper> resolver = this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE);
        if (resolver == null) {
            return null;
        }
        return resolver.getContext(ObjectMapper.class);
    }
}

