/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        return ConversionUtils.convert(value, clazz, Object::toString);
    }

    public static <T> T convert(Object value, Class<T> clazz, Function<Object, String> stringConverter) {
        if (value == null || clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        for (Method method : clazz.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers) || method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class) || !clazz.isAssignableFrom(method.getReturnType())) continue;
            try {
                return clazz.cast(method.invoke(null, stringConverter.apply(value)));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            return clazz.getConstructor(String.class).newInstance(stringConverter.apply(value));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalArgumentException(value + " cannot be converted to " + clazz.getName());
        }
    }

    public static String toCamelCase(String text) {
        StringBuilder builder = new StringBuilder();
        boolean convertNextCharToUpper = false;
        for (int i = 0; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (!Character.isLetterOrDigit(currentChar)) {
                convertNextCharToUpper = true;
                continue;
            }
            if (convertNextCharToUpper) {
                builder.append(Character.toUpperCase(currentChar));
                convertNextCharToUpper = false;
                continue;
            }
            builder.append(currentChar);
            convertNextCharToUpper = false;
        }
        if (builder.length() > 0) {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    public static String concatPaths(String onePath, String anotherPath) {
        return ConversionUtils.concatPaths(onePath, anotherPath, "/");
    }

    public static String concatPaths(String onePath, String anotherPath, String concatChars) {
        if (anotherPath.startsWith(concatChars)) {
            if (onePath.endsWith(concatChars)) {
                return onePath.concat(anotherPath.substring(concatChars.length()));
            }
            return onePath.concat(anotherPath);
        }
        if (onePath.endsWith(concatChars)) {
            return onePath.concat(anotherPath);
        }
        return onePath.concat(concatChars).concat(anotherPath);
    }

    public static boolean isEmpty(String value) {
        return Objects.isNull(value) || value.isBlank();
    }
}

