/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.api;

import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.api.URIBuilder;

public class JobCallbackResourceDef {
    public static final String PROCESS_ID = "processId";
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String TIMER_ID = "timerId";
    public static final String LIMIT = "limit";
    public static final String LIMIT_DEFAULT_VALUE = "0";
    public static final String JOBS_CALLBACK_URI = "/management/jobs";
    public static final String JOBS_CALLBACK_POST_URI = "{processId}/instances/{processInstanceId}/timers/{timerId}";

    private JobCallbackResourceDef() {
    }

    public static String buildCallbackURI(ProcessInstanceJobDescription description, String jobsCallbackEndpoint) {
        return URIBuilder.toURI(jobsCallbackEndpoint + "/management/jobs/" + description.processId() + "/instances/" + description.processInstanceId() + "/timers/" + description.id()).toString();
    }

    public static Job buildCallbackPatternJob(ProcessInstanceJobDescription description, String callback) {
        return JobBuilder.builder().id(description.id()).expirationTime(description.expirationTime().get()).repeatInterval(description.expirationTime().repeatInterval()).repeatLimit(description.expirationTime().repeatLimit()).priority(0).callbackEndpoint(callback).processId(description.processId()).processInstanceId(description.processInstanceId()).rootProcessId(description.rootProcessId()).rootProcessInstanceId(description.rootProcessInstanceId()).nodeInstanceId(description.nodeInstanceId()).build();
    }
}

