/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.utils;

import java.util.function.Predicate;
import org.apache.commons.math3.util.Precision;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;

public class ConverterTypeUtil {
    static final String FAILED_CONVERSION = "Failed to convert %s to %s";
    private static Predicate<Class<?>> IS_BOOLEAN = expectedClass -> expectedClass.isAssignableFrom(Boolean.class) || expectedClass.isAssignableFrom(Boolean.TYPE);
    private static Predicate<Class<?>> IS_INTEGER = expectedClass -> expectedClass.isAssignableFrom(Integer.class) || expectedClass.isAssignableFrom(Integer.TYPE);
    private static Predicate<Class<?>> IS_LONG = expectedClass -> expectedClass.isAssignableFrom(Long.class) || expectedClass.isAssignableFrom(Long.TYPE);
    private static Predicate<Class<?>> IS_DOUBLE = expectedClass -> expectedClass.isAssignableFrom(Double.class) || expectedClass.isAssignableFrom(Double.TYPE);
    private static Predicate<Class<?>> IS_FLOAT = expectedClass -> expectedClass.isAssignableFrom(Float.class) || expectedClass.isAssignableFrom(Float.TYPE);
    private static Predicate<Class<?>> IS_CHARACTER = expectedClass -> expectedClass.isAssignableFrom(Character.class) || expectedClass.isAssignableFrom(Character.TYPE);
    private static Predicate<Class<?>> IS_BYTE = expectedClass -> expectedClass.isAssignableFrom(Byte.class) || expectedClass.isAssignableFrom(Byte.TYPE);
    private static Predicate<Class<?>> IS_SHORT = expectedClass -> expectedClass.isAssignableFrom(Short.class) || expectedClass.isAssignableFrom(Short.TYPE);

    private ConverterTypeUtil() {
    }

    public static Object convert(Class<?> expectedClass, Object originalObject) {
        Object toReturn;
        String currentClassName;
        if (originalObject == null) {
            return null;
        }
        Class<?> currentClass = originalObject.getClass();
        if (expectedClass.isAssignableFrom(currentClass)) {
            return originalObject;
        }
        if (PrimitiveBoxedUtils.areSameWithBoxing(expectedClass, originalObject.getClass())) {
            return originalObject;
        }
        if (expectedClass == String.class) {
            return originalObject.toString();
        }
        switch (currentClassName = currentClass.getName()) {
            case "java.lang.String": {
                toReturn = ConverterTypeUtil.convertFromString(expectedClass, (String)originalObject);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                toReturn = ConverterTypeUtil.convertFromInteger(expectedClass, (Integer)originalObject);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                toReturn = ConverterTypeUtil.convertFromDouble(expectedClass, (Double)originalObject);
                break;
            }
            case "float": 
            case "java.lang.Float": {
                toReturn = ConverterTypeUtil.convertFromFloat(expectedClass, (Float)originalObject);
                break;
            }
            default: {
                throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
            }
        }
        return toReturn;
    }

    static Object convertFromInteger(Class<?> expectedClass, Integer originalObject) {
        if (IS_DOUBLE.test(expectedClass)) {
            return originalObject.doubleValue();
        }
        if (IS_LONG.test(expectedClass)) {
            return originalObject.longValue();
        }
        if (IS_FLOAT.test(expectedClass)) {
            return Float.valueOf(originalObject.floatValue());
        }
        if (IS_BYTE.test(expectedClass)) {
            return originalObject.byteValue();
        }
        if (IS_SHORT.test(expectedClass)) {
            return originalObject.shortValue();
        }
        throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
    }

    static Object convertFromDouble(Class<?> expectedClass, Double originalObject) {
        if (IS_INTEGER.test(expectedClass)) {
            return (int)Precision.round(originalObject, 0, 4);
        }
        if (IS_LONG.test(expectedClass)) {
            return (long)Precision.round(originalObject, 0, 4);
        }
        if (IS_FLOAT.test(expectedClass)) {
            return Float.valueOf(originalObject.floatValue());
        }
        if (IS_BYTE.test(expectedClass)) {
            return (byte)Precision.round(originalObject, 0, 4);
        }
        if (IS_SHORT.test(expectedClass)) {
            return (short)Precision.round(originalObject, 0, 4);
        }
        throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
    }

    static Object convertFromFloat(Class<?> expectedClass, Float originalObject) {
        if (IS_INTEGER.test(expectedClass)) {
            return (int)Precision.round(originalObject.floatValue(), 0, 4);
        }
        if (IS_LONG.test(expectedClass)) {
            return (long)Precision.round(originalObject.floatValue(), 0, 4);
        }
        if (IS_DOUBLE.test(expectedClass)) {
            return originalObject.doubleValue();
        }
        if (IS_BYTE.test(expectedClass)) {
            return (byte)Precision.round(originalObject.floatValue(), 0, 4);
        }
        if (IS_SHORT.test(expectedClass)) {
            return (short)Precision.round(originalObject.floatValue(), 0, 4);
        }
        throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
    }

    static Object convertFromString(Class<?> expectedClass, String originalObject) {
        try {
            if (IS_BOOLEAN.test(expectedClass)) {
                return ConverterTypeUtil.parseBoolean(originalObject);
            }
            if (IS_INTEGER.test(expectedClass)) {
                return Integer.parseInt(originalObject);
            }
            if (IS_LONG.test(expectedClass)) {
                return Long.parseLong(originalObject);
            }
            if (IS_DOUBLE.test(expectedClass)) {
                return Double.parseDouble(originalObject);
            }
            if (IS_FLOAT.test(expectedClass)) {
                return Float.valueOf(Float.parseFloat(originalObject));
            }
            if (IS_CHARACTER.test(expectedClass)) {
                return Character.valueOf(ConverterTypeUtil.parseChar(originalObject));
            }
            if (IS_BYTE.test(expectedClass)) {
                return Byte.parseByte(originalObject);
            }
            if (IS_SHORT.test(expectedClass)) {
                return Short.parseShort(originalObject);
            }
            throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
        }
        catch (Exception e) {
            throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
        }
    }

    private static boolean parseBoolean(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Impossible to parse as boolean " + value);
    }

    private static char parseChar(String value) {
        if (value == null || value.length() != 1) {
            throw new IllegalArgumentException("Impossible to transform " + value + " as char");
        }
        return value.charAt(0);
    }
}

