/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan.marshaller;

import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.repository.infinispan.marshaller.BaseMarshaller;
import org.kie.kogito.jobs.service.repository.marshaller.RecipientMarshaller;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;

public class JobDetailsMarshaller
extends BaseMarshaller<JobDetails> {
    private RecipientMarshaller recipientMarshaller;

    public JobDetailsMarshaller(RecipientMarshaller recipientMarshaller) {
        this.recipientMarshaller = recipientMarshaller;
    }

    public String getTypeName() {
        return this.getPackage() + ".JobDetails";
    }

    public Class<? extends JobDetails> getJavaClass() {
        return JobDetails.class;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, JobDetails job) throws IOException {
        writer.writeString("id", job.getId());
        writer.writeString("correlationId", job.getCorrelationId());
        writer.writeString("status", this.mapEnum((Enum<?>)job.getStatus()));
        writer.writeInstant("lastUpdate", DateUtil.zonedDateTimeToInstant((ZonedDateTime)job.getLastUpdate()));
        writer.writeInt("retries", job.getRetries());
        writer.writeInt("priority", job.getPriority());
        writer.writeInt("executionCounter", job.getExecutionCounter());
        writer.writeString("scheduledId", job.getScheduledId());
        writer.writeString("recipient", (String)Optional.ofNullable(job.getRecipient()).map(r -> this.recipientMarshaller.marshall(r).encode()).orElse(null));
        writer.writeObject("trigger", (Object)job.getTrigger(), this.getInterface(job.getTrigger()));
        writer.writeLong("executionTimeout", job.getExecutionTimeout());
        writer.writeString("executionTimeoutUnit", job.getExecutionTimeoutUnit() != null ? job.getExecutionTimeoutUnit().name() : null);
    }

    public Class<?> getInterface(Object object) {
        return Optional.ofNullable(object).map(Object::getClass).map(Class::getInterfaces).map(i -> i[0]).orElse(null);
    }

    public JobDetails readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String id = reader.readString("id");
        String correlationId = reader.readString("correlationId");
        JobStatus status = this.mapString(reader.readString("status"), JobStatus.class);
        ZonedDateTime lastUpdate = DateUtil.instantToZonedDateTime((Instant)reader.readInstant("lastUpdate"));
        Integer retries = reader.readInt("retries");
        Integer priority = reader.readInt("priority");
        Integer executionCounter = reader.readInt("executionCounter");
        String scheduledId = reader.readString("scheduledId");
        Recipient recipient = Optional.ofNullable(reader.readString("recipient")).map(r -> this.recipientMarshaller.unmarshall(new JsonObject(r))).orElse(null);
        Trigger trigger = (Trigger)reader.readObject("trigger", Trigger.class);
        Long executionTimeout = reader.readLong("executionTimeout");
        String executionTimeoutUnit = reader.readString("executionTimeoutUnit");
        return JobDetails.builder().id(id).correlationId(correlationId).status(status).lastUpdate(lastUpdate).retries(retries).priority(priority).executionCounter(executionCounter).scheduledId(scheduledId).recipient(recipient).trigger(trigger).executionTimeout(executionTimeout).executionTimeoutUnit(executionTimeoutUnit != null ? ChronoUnit.valueOf(executionTimeoutUnit) : null).build();
    }
}

