/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigProducerUtil;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class ConfigRecorder {
    public void validateConfigProperties(Set<ConfigValidationMetadata> properties) {
        Config config = ConfigProvider.getConfig();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConfigRecorder.class.getClassLoader();
        }
        for (ConfigValidationMetadata property : properties) {
            Class<Object> propertyClass = this.load(property.getType(), cl);
            if (propertyClass.isArray() || propertyClass.getTypeParameters().length > 0) {
                propertyClass = String.class;
            }
            try {
                ConfigProducerUtil.getValue(property.getName(), propertyClass, property.getDefaultValue(), config);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to load config value of type " + propertyClass + " for: " + property.getName(), e);
            }
        }
    }

    public void registerConfigMappings(Set<ConfigMappings.ConfigClassWithPrefix> configClasses) {
        try {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
            ConfigMappings.registerConfigMappings(config, configClasses);
        }
        catch (ConfigValidationException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void registerConfigProperties(Set<ConfigMappings.ConfigClassWithPrefix> configClasses) {
        try {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
            ConfigMappings.registerConfigProperties(config, configClasses);
        }
        catch (ConfigValidationException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private Class<?> load(String className, ClassLoader cl) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the config property type: " + className, e);
        }
    }

    public static class ConfigValidationMetadata {
        private String name;
        private String type;
        private String defaultValue;

        public ConfigValidationMetadata() {
        }

        public ConfigValidationMetadata(String name, String type, String defaultValue) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigValidationMetadata that = (ConfigValidationMetadata)o;
            return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.defaultValue, that.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.defaultValue);
        }
    }
}

