/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.ContextUtil;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.Filter30Dispatcher;

public class ResteasyFilter
extends Filter30Dispatcher {
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (request.getMethod().equals("GET") || request.getMethod().equals("HEAD") || this.isCORSPreflightRequest(request)) {
            filterChain.doFilter(servletRequest, (ServletResponse)new ResteasyResponseWrapper(response, request));
        } else {
            CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
            ContextUtil.pushContext(currentVertxRequest.getCurrent());
            this.servletContainerDispatcher.service(request.getMethod(), request, response, true);
        }
    }

    private boolean isCORSPreflightRequest(HttpServletRequest request) {
        return request.getMethod().equals("OPTIONS") && request.getHeader("Origin") != null && request.getHeader("Access-Control-Request-Method") != null && request.getHeader("Access-Control-Request-Headers") != null;
    }

    private class ResteasyResponseWrapper
    extends HttpServletResponseWrapper {
        final HttpServletRequest request;
        final HttpServletResponse response;

        public ResteasyResponseWrapper(HttpServletResponse response, HttpServletRequest request) {
            super(response);
            this.request = request;
            this.response = response;
        }

        public void sendError(int sc, String msg) throws IOException {
            if (sc == 404 || sc == 403) {
                this.service();
            } else {
                super.sendError(sc, msg);
            }
        }

        protected void service() throws IOException {
            CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
            ContextUtil.pushContext(currentVertxRequest.getCurrent());
            ResteasyFilter.this.servletContainerDispatcher.service(this.request.getMethod(), this.request, this.response, true);
        }

        public void sendError(int sc) throws IOException {
            if (sc == 404 || sc == 403) {
                this.service();
            } else {
                super.sendError(sc);
            }
        }
    }
}

