/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.http.runtime.devmode.Json;
import io.quarkus.vertx.http.runtime.logstream.HistoryHandler;
import io.quarkus.vertx.http.runtime.logstream.LogController;
import io.quarkus.vertx.http.runtime.logstream.WebSocketHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class LogStreamWebSocket
implements io.vertx.core.Handler<RoutingContext> {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(LogStreamWebSocket.class.getName());
    private final HistoryHandler historyHandler;
    private final String initMessage;
    private final ExtHandler rootHandler;
    private final Logger rootLogger;
    private static final String TYPE = "type";
    private static final String INIT = "init";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String UPDATE = "update";

    public LogStreamWebSocket(HistoryHandler historyHandler) {
        this.historyHandler = historyHandler;
        LogContext logContext = LogContext.getLogContext();
        this.rootLogger = logContext.getLogger("");
        this.rootHandler = this.findCorrectHandler(this.rootLogger.getHandlers());
        this.initMessage = this.createInitMessage();
    }

    @Override
    public void handle(RoutingContext event) {
        if ("websocket".equalsIgnoreCase(event.request().getHeader(HttpHeaderNames.UPGRADE)) && !event.request().isEnded()) {
            event.request().toWebSocket(new io.vertx.core.Handler<AsyncResult<ServerWebSocket>>(){

                @Override
                public void handle(AsyncResult<ServerWebSocket> event) {
                    if (event.succeeded()) {
                        ServerWebSocket socket = event.result();
                        final SessionState state = new SessionState();
                        WebSocketHandler webSocketHandler = new WebSocketHandler(socket);
                        state.handler = webSocketHandler;
                        state.session = socket;
                        socket.closeHandler((io.vertx.core.Handler)new io.vertx.core.Handler<Void>(){

                            @Override
                            public void handle(Void event) {
                                LogStreamWebSocket.this.stop(state);
                            }
                        });
                        socket.textMessageHandler(new io.vertx.core.Handler<String>(){

                            @Override
                            public void handle(String event) {
                                LogStreamWebSocket.this.onMessage(event, state);
                            }
                        });
                        socket.writeTextMessage(LogStreamWebSocket.this.initMessage.toString());
                        LogStreamWebSocket.this.start(state);
                    } else {
                        log.log(Level.SEVERE, "Failed to connect to log server", event.cause());
                    }
                }
            });
        } else {
            event.next();
        }
    }

    public void onMessage(String message, SessionState session) {
        if (message != null && !message.isEmpty()) {
            if (message.equalsIgnoreCase(START)) {
                this.start(session);
            } else if (message.equalsIgnoreCase(STOP)) {
                this.stop(session);
            } else if (message.startsWith(UPDATE)) {
                this.update(message);
            }
        }
    }

    private void start(SessionState session) {
        if (!session.started) {
            session.started = true;
            this.rootLogger.addHandler(session.handler);
            if (this.historyHandler.hasHistory()) {
                List<ExtLogRecord> history = this.historyHandler.getHistory();
                for (ExtLogRecord lr : history) {
                    session.handler.publish(lr);
                }
            }
        }
    }

    private void stop(SessionState session) {
        this.rootLogger.removeHandler(session.handler);
        session.started = false;
    }

    private void update(String message) {
        String[] p = message.split("\\|");
        if (p.length == 3) {
            String loggerName = p[1];
            String levelVal = p[2];
            LogController.updateLogLevel(loggerName, levelVal);
        }
    }

    private void addHandler(ExtHandler extHandler) {
        if (this.rootHandler != null) {
            this.rootHandler.addHandler(extHandler);
        } else {
            this.rootLogger.addHandler(extHandler);
        }
    }

    private void removeHandler(ExtHandler extHandler) {
        if (this.rootHandler != null) {
            this.rootHandler.removeHandler(extHandler);
        } else {
            this.rootLogger.removeHandler(extHandler);
        }
    }

    private ExtHandler findCorrectHandler(Handler[] handlers) {
        for (Handler h : handlers) {
            ExtHandler exth;
            ExtHandler consoleLogger;
            if (!(h instanceof ExtHandler) || (consoleLogger = this.getConsoleHandler((exth = (ExtHandler)h).getHandlers())) == null) continue;
            return exth;
        }
        for (Handler h : handlers) {
            if (!(h instanceof ExtHandler)) continue;
            return (ExtHandler)h;
        }
        return null;
    }

    private ExtHandler getConsoleHandler(Handler[] handlers) {
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                if (!h.getClass().equals(ConsoleHandler.class)) continue;
                return (ExtHandler)h;
            }
        }
        return null;
    }

    private String createInitMessage() {
        Json.JsonObjectBuilder initMessage = Json.object();
        initMessage.put(TYPE, INIT);
        initMessage.put("loggers", LogController.getLoggers());
        initMessage.put("levels", LogController.getLevels());
        return initMessage.build();
    }

    static class SessionState {
        ServerWebSocket session;
        ExtHandler handler;
        boolean started;

        SessionState() {
        }
    }
}

