/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public abstract class BaseHealth {
    public static final String CONNECTION_COUNT_METRIC_NAME = "connection-count";
    protected final String channel;

    public BaseHealth(String channel) {
        this.channel = channel;
    }

    public void close() {
        KafkaAdminClient admin = this.getAdmin();
        if (admin != null) {
            try {
                admin.closeAndAwait();
            }
            catch (Throwable e) {
                KafkaLogging.log.exceptionOnClose(e);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        KafkaAdminClient admin = this.getAdmin();
        if (admin != null) {
            this.adminBasedHealthCheck(builder);
        } else {
            this.metricsBasedHealthCheck(builder);
        }
    }

    public Metric getMetric(Map<MetricName, ? extends Metric> metrics) {
        Metric metric = null;
        for (MetricName metricName : metrics.keySet()) {
            if (!metricName.name().equals(CONNECTION_COUNT_METRIC_NAME)) continue;
            metric = metrics.get(metricName);
            break;
        }
        return metric;
    }

    protected abstract void metricsBasedHealthCheck(HealthReport.HealthReportBuilder var1);

    protected abstract void adminBasedHealthCheck(HealthReport.HealthReportBuilder var1);

    public abstract KafkaAdminClient getAdmin();
}

